/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.noear.solon.core.FieldWrap;
import org.noear.solon.core.MethodWrap;
import org.noear.solon.core.XContext;
import org.noear.solon.core.utils.TypeUtil;

public class ClassWrap {
    private static Map<Class<?>, ClassWrap> _cache = new ConcurrentHashMap();
    public final Class<?> clazz;
    public final List<MethodWrap> methodWraps;
    public final Field[] fields;
    private final Map<String, FieldWrap> fieldWraps;

    public static ClassWrap get(Class<?> clz) {
        ClassWrap l;
        ClassWrap cw = _cache.get(clz);
        if (cw == null && (l = _cache.putIfAbsent(clz, cw = new ClassWrap(clz))) != null) {
            cw = l;
        }
        return cw;
    }

    protected ClassWrap(Class<?> clz) {
        this.clazz = clz;
        this.fields = clz.getDeclaredFields();
        this.methodWraps = new ArrayList<MethodWrap>();
        for (Method m : clz.getDeclaredMethods()) {
            this.methodWraps.add(MethodWrap.get(m));
        }
        this.fieldWraps = new ConcurrentHashMap<String, FieldWrap>();
        ClassWrap.scanAllFields(clz, this.fieldWraps::containsKey, this.fieldWraps::put);
    }

    private static void scanAllFields(Class<?> clz, Predicate<String> checker, BiConsumer<String, FieldWrap> consumer) {
        if (clz == null) {
            return;
        }
        for (Field f : clz.getDeclaredFields()) {
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod)) continue;
            f.setAccessible(true);
            if (checker.test(f.getName())) continue;
            consumer.accept(f.getName(), new FieldWrap(clz, f));
        }
        Class<?> sup = clz.getSuperclass();
        if (sup != Object.class) {
            ClassWrap.scanAllFields(sup, checker, consumer);
        }
    }

    public FieldWrap getFieldWrap(Field f1) {
        FieldWrap fw = this.fieldWraps.get(f1.getName());
        if (fw == null) {
            fw = new FieldWrap(this.clazz, f1);
            FieldWrap l = this.fieldWraps.putIfAbsent(f1.getName(), fw);
            if (l != null) {
                fw = l;
            }
        }
        return fw;
    }

    public <T> T newBy(Function<String, String> data) {
        try {
            Object obj = this.clazz.newInstance();
            this.fill(obj, data, null);
            return (T)obj;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void fill(Object target, Function<String, String> data, XContext ctx) {
        for (Map.Entry<String, FieldWrap> kv : this.fieldWraps.entrySet()) {
            String key = kv.getKey();
            String val0 = data.apply(key);
            if (val0 == null) continue;
            FieldWrap fw = kv.getValue();
            Object val = TypeUtil.changeOfCtx(fw.field, fw.type, key, val0, ctx);
            fw.setValue(target, val);
        }
    }
}

