/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.sse;

import java.io.IOException;
import java.util.function.Consumer;
import org.noear.solon.core.util.ConsumerEx;
import org.noear.solon.web.sse.SseEmitterHandler;
import org.noear.solon.web.sse.SseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SseEmitter {
    static final Logger log = LoggerFactory.getLogger(SseEmitter.class);
    private SseEmitterHandler handler;
    protected Runnable onCompletion;
    protected Runnable onTimeout;
    protected Consumer<Throwable> onError;
    protected ConsumerEx<SseEmitter> onInited;
    protected long timeout;

    public SseEmitter onCompletion(Runnable onCompletion) {
        this.onCompletion = onCompletion;
        return this;
    }

    public SseEmitter onTimeout(Runnable onTimeout) {
        this.onTimeout = onTimeout;
        return this;
    }

    public SseEmitter onError(Consumer<Throwable> onError) {
        this.onError = onError;
        return this;
    }

    public SseEmitter onInited(ConsumerEx<SseEmitter> onInited) {
        this.onInited = onInited;
        return this;
    }

    public SseEmitter(long timeout) {
        this.timeout = timeout;
    }

    public void send(String data) throws IOException {
        this.send(new SseEvent().data(data));
    }

    public void send(SseEvent event) throws IOException {
        this.handler.send(event);
    }

    public void complete() {
        try {
            this.handler.complete();
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    protected void initialize(SseEmitterHandler handler) throws Throwable {
        this.handler = handler;
        if (this.onInited != null) {
            this.onInited.accept((Object)this);
        }
    }
}

