/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.web.servlet.SolonServletContext;

class MultipartUtil {
    MultipartUtil() {
    }

    public static void buildParamsAndFiles(SolonServletContext context, Map<String, List<UploadedFile>> filesMap) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)context.request();
        for (Part part : request.getParts()) {
            if (MultipartUtil.isFile(part)) {
                MultipartUtil.doBuildFiles(context, filesMap, part);
                continue;
            }
            if (request.getParameterMap() != null && !request.getParameterMap().isEmpty()) continue;
            context.paramSet(part.getName(), IoUtil.transferToString((InputStream)part.getInputStream(), (String)ServerProps.request_encoding));
        }
    }

    private static void doBuildFiles(SolonServletContext context, Map<String, List<UploadedFile>> filesMap, Part part) throws IOException {
        List<UploadedFile> list = filesMap.get(part.getName());
        if (list == null) {
            list = new ArrayList<UploadedFile>();
            filesMap.put(part.getName(), list);
        }
        String contentType = part.getContentType();
        long contentSize = part.getSize();
        InputStream content = part.getInputStream();
        String name = part.getSubmittedFileName();
        String extension = null;
        int idx = name.lastIndexOf(".");
        if (idx > 0) {
            extension = name.substring(idx + 1);
        }
        UploadedFile f1 = new UploadedFile(() -> ((Part)part).delete(), contentType, contentSize, content, name, extension);
        list.add(f1);
    }

    private static boolean isField(Part filePart) {
        return filePart.getSubmittedFileName() == null;
    }

    private static boolean isFile(Part filePart) {
        return !MultipartUtil.isField(filePart);
    }
}

