/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRegistration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.event.AppInitEndEvent;
import org.noear.solon.core.event.AppLoadEndEvent;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.ContextPathFilter;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.web.servlet.SolonServletHandler;

public class SolonServletContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        EventBus.subscribe(AppInitEndEvent.class, e -> {
            Solon.app().enableHttp(false);
            Solon.cfg().isFilesMode(false);
            String contextPath = sce.getServletContext().getContextPath();
            if (contextPath.length() > 1) {
                Solon.app().filter(-99, (Filter)new ContextPathFilter(contextPath));
            }
        });
        EventBus.subscribe(AppLoadEndEvent.class, e -> {
            ServletRegistration.Dynamic registration = sce.getServletContext().addServlet("solon", SolonServletHandler.class);
            registration.addMapping(new String[]{"/*"});
        });
        this.invokeMain(sce.getServletContext(), new String[0]);
    }

    private void invokeMain(ServletContext sc, String[] strArgs) throws RuntimeException {
        Class mainClass = this.getClass();
        String mainClassStr = sc.getInitParameter("solonStartClass");
        if (Utils.isNotEmpty((String)mainClassStr) && (mainClass = ClassUtil.loadClass((String)mainClassStr)) == null) {
            throw new IllegalStateException("The start class was not found: '" + mainClassStr + "'");
        }
        Method mainMethod = null;
        try {
            mainMethod = mainClass.getMethod("main", String[].class);
        }
        catch (Exception ex) {
            mainMethod = null;
        }
        if (mainMethod != null && Modifier.isStatic(mainMethod.getModifiers())) {
            try {
                mainMethod.invoke(null, new Object[]{strArgs});
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException(e);
            }
        } else {
            throw new IllegalStateException("The main function was not found for: " + this.getClass().getName());
        }
    }
}

