/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.velocity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.noear.solon.XApp;
import org.noear.solon.XProperties;
import org.noear.solon.XUtil;
import org.noear.solon.core.ModelAndView;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XRender;

public class VelocityRenderImp
implements XRender {
    private VelocityEngine velocity = new VelocityEngine();
    private Map<String, Object> _sharedVariable = new HashMap<String, Object>();
    private String _baseUri = "/WEB-INF/view/";

    public VelocityRenderImp() {
        XProperties props = XApp.global().prop();
        String baseUri = props.get("slon.mvc.view.prefix");
        if (!XUtil.isEmpty((String)baseUri)) {
            this._baseUri = baseUri;
        }
        String root_path = XUtil.getResource((String)this._baseUri).getPath();
        this.velocity.setProperty("file.resource.loader.cache", true);
        this.velocity.setProperty("file.resource.loader.path", root_path);
        this.velocity.setProperty("UTF-8", this.getEncoding());
        this.velocity.setProperty("input.encoding", this.getEncoding());
        if (props != null) {
            props.forEach((k, v) -> {
                String key = k.toString();
                if (key.startsWith("veloci")) {
                    this.velocity.setProperty(key, v);
                }
            });
        }
        this.velocity.init();
    }

    public void loadDirective(Object obj) {
        this.velocity.loadDirective(obj.getClass().getName());
    }

    public void setSharedVariable(String key, Object obj) {
        this._sharedVariable.put(key, obj);
    }

    public String getEncoding() {
        return "utf-8";
    }

    public void render(Object obj, XContext ctx) throws Exception {
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx);
        } else {
            this.render_obj(obj, ctx);
        }
    }

    private void render_obj(Object obj, XContext ctx) throws Exception {
        boolean is_rpc = "service".equals(ctx.attr("solon.reader.source", null));
        if (!is_rpc) {
            if (obj instanceof String) {
                ctx.output((String)obj);
                return;
            }
            if (obj instanceof Exception) {
                throw (Exception)obj;
            }
        }
        String txt = null;
        txt = is_rpc ? JSON.toJSONString(obj, SerializerFeature.BrowserCompatible, SerializerFeature.WriteClassName, SerializerFeature.DisableCircularReferenceDetect) : JSON.toJSONString(obj, SerializerFeature.BrowserCompatible, SerializerFeature.DisableCircularReferenceDetect);
        ctx.attrSet("output", (Object)txt);
        ctx.outputAsJson(txt);
    }

    public void render_mav(ModelAndView mv, XContext cxt) throws Exception {
        if (XUtil.isEmpty((String)mv.view())) {
            this.render_obj(mv, cxt);
            return;
        }
        cxt.contentType("text/html;charset=utf-8");
        String view = mv.view();
        Template t = this.velocity.getTemplate(view, this.getEncoding());
        VelocityContext vc = new VelocityContext(mv.model());
        this._sharedVariable.forEach((k, v) -> vc.put((String)k, v));
        PrintWriter writer = new PrintWriter(cxt.outputStream());
        t.merge(vc, writer);
    }
}

