/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.thymeleaf;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.SupplierEx;
import org.noear.solon.view.ViewConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafRender
implements Render {
    static final Logger log = LoggerFactory.getLogger(ThymeleafRender.class);
    private static ThymeleafRender _global;
    private Map<String, Object> sharedVariables = new HashMap<String, Object>();
    private ClassLoader classLoader;
    private TemplateEngine provider = new TemplateEngine();

    public static ThymeleafRender global() {
        if (_global == null) {
            _global = new ThymeleafRender();
        }
        return _global;
    }

    public TemplateEngine getProvider() {
        return this.provider;
    }

    public ThymeleafRender() {
        this((ClassLoader)AppClassLoader.global());
    }

    public ThymeleafRender(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.forDebug();
        this.forRelease();
        Solon.app().shared().forEach((k, v) -> this.putVariable((String)k, v));
        Solon.app().onSharedAdd((k, v) -> this.putVariable((String)k, v));
    }

    private void forDebug() {
        String dir_str;
        if (!Solon.cfg().isDebugMode()) {
            return;
        }
        if (!Solon.cfg().isFilesMode()) {
            return;
        }
        URL rooturi = ResourceUtil.getResource((String)"/");
        if (rooturi == null) {
            return;
        }
        String rootdir = rooturi.toString().replace("target/classes/", "");
        File dir = null;
        if (rootdir.startsWith("file:") && !(dir = new File(URI.create(dir_str = rootdir + "src/main/resources" + ViewConfig.getViewPrefix()))).exists()) {
            dir_str = rootdir + "src/main/webapp" + ViewConfig.getViewPrefix();
            dir = new File(URI.create(dir_str));
        }
        try {
            if (dir != null && dir.exists()) {
                FileTemplateResolver _loader = new FileTemplateResolver();
                _loader.setPrefix(dir.getAbsolutePath() + File.separatorChar);
                _loader.setTemplateMode(TemplateMode.HTML);
                _loader.setCacheable(false);
                _loader.setCharacterEncoding("utf-8");
                _loader.setCacheTTLMs(Long.valueOf(3600000L));
                this.provider.addTemplateResolver((ITemplateResolver)_loader);
            }
            EventBus.publish((Object)this.provider);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void forRelease() {
        ClassLoaderTemplateResolver _loader = new ClassLoaderTemplateResolver(this.classLoader);
        _loader.setPrefix(ViewConfig.getViewPrefix());
        _loader.setTemplateMode(TemplateMode.HTML);
        _loader.setCacheable(true);
        _loader.setCharacterEncoding("utf-8");
        _loader.setCacheTTLMs(Long.valueOf(3600000L));
        this.provider.addTemplateResolver((ITemplateResolver)_loader);
        EventBus.publish((Object)this.provider);
    }

    public <T extends IDialect> void putDirective(T obj) {
        try {
            this.provider.addDialect(obj);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void putVariable(String name, Object obj) {
        this.sharedVariables.put(name, obj);
    }

    public void render(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> ctx.outputStream()));
        } else {
            ctx.output(obj.toString());
        }
    }

    public String renderAndReturn(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ModelAndView) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> outputStream));
            return outputStream.toString();
        }
        return obj.toString();
    }

    public void render_mav(ModelAndView mv, Context ctx, SupplierEx<OutputStream> outputStream) throws Throwable {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=utf-8");
        }
        if (ViewConfig.isOutputMeta()) {
            ctx.headerSet("Solon-View", "ThymeleafRender");
        }
        mv.putIfAbsent("context", (Object)ctx);
        org.thymeleaf.context.Context context = new org.thymeleaf.context.Context();
        context.setVariables(this.sharedVariables);
        context.setVariables(mv.model());
        if (ctx.getLocale() != null) {
            context.setLocale(ctx.getLocale());
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream.get(), ServerProps.response_encoding));
        this.provider.process(mv.view(), (IContext)context, (Writer)writer);
        writer.flush();
    }
}

