/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.thymeleaf;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.auth.AuthUtil;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.view.thymeleaf.ThymeleafRender;
import org.noear.solon.view.thymeleaf.tags.AuthDialect;
import org.noear.solon.view.thymeleaf.tags.AuthPermissionsTag;
import org.noear.solon.view.thymeleaf.tags.AuthRolesTag;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.processor.IProcessor;

public class XPluginImp
implements Plugin {
    public static boolean output_meta = false;

    public void start(AopContext context) {
        output_meta = Solon.cfg().getInt("solon.output.meta", 0) > 0;
        ThymeleafRender render = ThymeleafRender.global();
        context.beanOnloaded(ctx -> ctx.beanForeach((k, v) -> {
            if (k.startsWith("view:")) {
                if (IDialect.class.isAssignableFrom(v.clz())) {
                    render.putDirective((IDialect)v.raw());
                }
                return;
            }
            if (k.startsWith("share:")) {
                render.putVariable(k.split(":")[1], v.raw());
                return;
            }
        }));
        RenderManager.register((Render)render);
        RenderManager.mapping((String)".html", (Render)render);
        if (Utils.hasClass(() -> AuthUtil.class)) {
            AuthDialect authDialect = new AuthDialect();
            authDialect.addProcessor((IProcessor)new AuthPermissionsTag(authDialect.getPrefix()));
            authDialect.addProcessor((IProcessor)new AuthRolesTag(authDialect.getPrefix()));
            render.putDirective(authDialect);
        }
    }
}

