/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr;

import com.jfinal.kit.JavaKeyword;
import com.jfinal.template.expr.NumTok;
import com.jfinal.template.expr.Sym;
import com.jfinal.template.expr.Tok;
import com.jfinal.template.stat.CharTable;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParaToken;
import com.jfinal.template.stat.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

class ExprLexer {
    static final char EOF = '\uffff';
    static final JavaKeyword javaKeyword = new JavaKeyword();
    static final Pattern DOUBLE_QUOTES_PATTERN = Pattern.compile("\\\\\"");
    static final Pattern SINGLE_QUOTES_PATTERN = Pattern.compile("\\\\'");
    char[] buf;
    int state = 0;
    int lexemeBegin = 0;
    int forward = 0;
    int beginRow = 1;
    int forwardRow = 1;
    List<Tok> tokens = new ArrayList<Tok>();
    Location location;

    public ExprLexer(ParaToken paraToken, Location location) {
        this.location = location;
        StringBuilder content = paraToken.getContent();
        this.forwardRow = this.beginRow = paraToken.getRow();
        if (content == null) {
            this.buf = new char[]{'\uffff'};
            return;
        }
        int len = content.length();
        this.buf = new char[len + 1];
        content.getChars(0, content.length(), this.buf, 0);
        this.buf[len] = 65535;
    }

    public List<Tok> scan() {
        while (this.peek() != '\uffff') {
            this.skipBlanks();
            this.lexemeBegin = this.forward;
            this.beginRow = this.forwardRow;
            if (this.scanId() || this.scanOperator() || this.scanString() || this.scanNumber() || this.peek() == '\uffff') continue;
            throw new ParseException("Expression not support the char: '" + this.peek() + "'", this.location);
        }
        return this.tokens;
    }

    boolean scanId() {
        if (this.state != 0) {
            return false;
        }
        if (!CharTable.isLetter(this.peek())) {
            return this.fail();
        }
        while (CharTable.isLetterOrDigit(this.next())) {
        }
        String id = this.subBuf(this.lexemeBegin, this.forward - 1).toString();
        if ("true".equals(id)) {
            this.addToken(new Tok(Sym.TRUE, id, this.beginRow));
        } else if ("false".equals(id)) {
            this.addToken(new Tok(Sym.FALSE, id, this.beginRow));
        } else if ("null".equals(id)) {
            this.addToken(new Tok(Sym.NULL, id, this.beginRow));
        } else {
            if (CharTable.isBlankOrLineFeed(this.peek()) && javaKeyword.contains(id)) {
                throw new ParseException("Identifier can not be java keyword : " + id, this.location);
            }
            this.addToken(new Tok(Sym.ID, id, this.beginRow));
        }
        return this.prepareNextScan();
    }

    boolean scanOperator() {
        if (this.state != 100) {
            return false;
        }
        switch (this.peek()) {
            case '+': {
                Tok tok;
                if (this.next() == '+') {
                    tok = new Tok(Sym.INC, this.beginRow);
                    this.next();
                } else {
                    tok = new Tok(Sym.ADD, this.beginRow);
                }
                return this.ok(tok);
            }
            case '-': {
                Tok tok;
                if (this.next() == '-') {
                    tok = new Tok(Sym.DEC, this.beginRow);
                    this.next();
                } else {
                    tok = new Tok(Sym.SUB, this.beginRow);
                }
                return this.ok(tok);
            }
            case '*': {
                Tok tok = new Tok(Sym.MUL, this.beginRow);
                this.next();
                return this.ok(tok);
            }
            case '/': {
                Tok tok = new Tok(Sym.DIV, this.beginRow);
                this.next();
                return this.ok(tok);
            }
            case '%': {
                Tok tok = new Tok(Sym.MOD, this.beginRow);
                this.next();
                return this.ok(tok);
            }
            case '=': {
                Tok tok;
                if (this.next() == '=') {
                    tok = new Tok(Sym.EQUAL, this.beginRow);
                    this.next();
                } else {
                    tok = new Tok(Sym.ASSIGN, this.beginRow);
                }
                return this.ok(tok);
            }
            case '!': {
                Tok tok;
                if (this.next() == '=') {
                    tok = new Tok(Sym.NOTEQUAL, this.beginRow);
                    this.next();
                } else {
                    tok = new Tok(Sym.NOT, this.beginRow);
                }
                return this.ok(tok);
            }
            case '<': {
                Tok tok;
                if (this.next() == '=') {
                    tok = new Tok(Sym.LE, this.beginRow);
                    this.next();
                } else {
                    tok = new Tok(Sym.LT, this.beginRow);
                }
                return this.ok(tok);
            }
            case '>': {
                Tok tok;
                if (this.next() == '=') {
                    tok = new Tok(Sym.GE, this.beginRow);
                    this.next();
                } else {
                    tok = new Tok(Sym.GT, this.beginRow);
                }
                return this.ok(tok);
            }
            case '&': {
                if (this.next() != '&') {
                    throw new ParseException("Unsupported operator: '&'", this.location);
                }
                Tok tok = new Tok(Sym.AND, this.beginRow);
                this.next();
                return this.ok(tok);
            }
            case '|': {
                if (this.next() != '|') {
                    throw new ParseException("Unsupported operator: '|'", this.location);
                }
                Tok tok = new Tok(Sym.OR, this.beginRow);
                this.next();
                return this.ok(tok);
            }
            case '?': {
                Tok tok;
                if (this.next() == '?') {
                    tok = new Tok(Sym.NULL_SAFE, this.beginRow);
                    this.next();
                } else {
                    tok = new Tok(Sym.QUESTION, this.beginRow);
                }
                return this.ok(tok);
            }
            case '.': {
                Tok tok;
                if (this.next() == '.') {
                    tok = new Tok(Sym.RANGE, this.beginRow);
                    this.next();
                } else {
                    tok = new Tok(Sym.DOT, ".", this.beginRow);
                }
                return this.ok(tok);
            }
            case ':': {
                Tok tok;
                if (this.next() == ':') {
                    tok = new Tok(Sym.STATIC, this.beginRow);
                    this.next();
                } else {
                    tok = new Tok(Sym.COLON, this.beginRow);
                }
                return this.ok(tok);
            }
            case ',': {
                Tok tok = new Tok(Sym.COMMA, this.beginRow);
                this.next();
                return this.ok(tok);
            }
            case ';': {
                Tok tok = new Tok(Sym.SEMICOLON, this.beginRow);
                this.next();
                return this.ok(tok);
            }
            case '(': {
                Tok tok = new Tok(Sym.LPAREN, this.beginRow);
                this.next();
                return this.ok(tok);
            }
            case ')': {
                Tok tok = new Tok(Sym.RPAREN, this.beginRow);
                this.next();
                return this.ok(tok);
            }
            case '[': {
                Tok tok = new Tok(Sym.LBRACK, this.beginRow);
                this.next();
                return this.ok(tok);
            }
            case ']': {
                Tok tok = new Tok(Sym.RBRACK, this.beginRow);
                this.next();
                return this.ok(tok);
            }
            case '{': {
                Tok tok = new Tok(Sym.LBRACE, this.beginRow);
                this.next();
                return this.ok(tok);
            }
            case '}': {
                Tok tok = new Tok(Sym.RBRACE, this.beginRow);
                this.next();
                return this.ok(tok);
            }
        }
        return this.fail();
    }

    boolean ok(Tok tok) {
        this.tokens.add(tok);
        return this.prepareNextScan();
    }

    boolean scanString() {
        if (this.state != 200) {
            return false;
        }
        char quotes = this.peek();
        if (quotes != '\"' && quotes != '\'') {
            return this.fail();
        }
        char c = this.next();
        while (true) {
            if (c == quotes) {
                if (this.buf[this.forward - 1] != '\\') {
                    StringBuilder sb = this.subBuf(this.lexemeBegin + 1, this.forward - 1);
                    String str = sb != null ? (quotes == '\"' ? DOUBLE_QUOTES_PATTERN.matcher(sb).replaceAll("\"") : SINGLE_QUOTES_PATTERN.matcher(sb).replaceAll("'")) : "";
                    Tok tok = new Tok(Sym.STR, str, this.beginRow);
                    this.addToken(tok);
                    this.next();
                    return this.prepareNextScan();
                }
            } else if (c == '\uffff') {
                throw new ParseException("Expression error, the string not ending", this.location);
            }
            c = this.next();
        }
    }

    boolean scanNumber() {
        StringBuilder num;
        if (this.state != 300) {
            return false;
        }
        char c = this.peek();
        if (!CharTable.isDigit(c)) {
            return this.fail();
        }
        int numStart = this.lexemeBegin;
        int radix = 10;
        if (c == '0') {
            c = this.next();
            if (c == 'X' || c == 'x') {
                radix = 16;
                c = this.next();
                numStart += 2;
            } else if (c != '.') {
                radix = 8;
            }
        }
        c = this.skipDigit(radix);
        Sym sym = null;
        if (c == '.') {
            this.next();
            if (this.peek() == '.' || CharTable.isLetter(this.peek())) {
                StringBuilder n = this.subBuf(numStart, this.forward - 2);
                if (n == null) {
                    throw new ParseException("Error hex format", this.location);
                }
                NumTok tok = new NumTok(Sym.INT, n.toString(), radix, false, this.location);
                this.addToken(tok);
                this.retract(1);
                return this.prepareNextScan();
            }
            sym = Sym.DOUBLE;
            c = this.skipDigit(radix);
        }
        boolean isScientificNotation = false;
        if (c == 'E' || c == 'e') {
            c = this.next();
            if (c == '+' || c == '-') {
                c = this.next();
            }
            if (!CharTable.isDigit(c)) {
                throw new ParseException("Error scientific notation format", this.location);
            }
            isScientificNotation = true;
            sym = Sym.DOUBLE;
            c = this.skipDecimalDigit();
        }
        if (c == 'L' || c == 'l') {
            if (sym == Sym.DOUBLE) {
                throw new ParseException("Error float format", this.location);
            }
            sym = Sym.LONG;
            this.next();
            num = this.subBuf(numStart, this.forward - 2);
        } else if (c == 'F' || c == 'f') {
            sym = Sym.FLOAT;
            this.next();
            num = this.subBuf(numStart, this.forward - 2);
        } else if (c == 'D' || c == 'd') {
            sym = Sym.DOUBLE;
            this.next();
            num = this.subBuf(numStart, this.forward - 2);
        } else {
            if (sym == null) {
                sym = Sym.INT;
            }
            num = this.subBuf(numStart, this.forward - 1);
        }
        if (this.errorFollow()) {
            throw new ParseException("Error expression: " + num + this.peek(), this.location);
        }
        if (num == null) {
            throw new ParseException("Error hex format", this.location);
        }
        NumTok tok = new NumTok(sym, num.toString(), radix, isScientificNotation, this.location);
        this.addToken(tok);
        return this.prepareNextScan();
    }

    boolean errorFollow() {
        char c = this.peek();
        return CharTable.isLetterOrDigit(c) || c == '\"' || c == '\'';
    }

    char skipDigit(int radix) {
        if (radix == 10) {
            return this.skipDecimalDigit();
        }
        if (radix == 16) {
            return this.skipHexadecimalDigit();
        }
        return this.skipOctalDigit();
    }

    char skipDecimalDigit() {
        char c = this.peek();
        while (CharTable.isDigit(c)) {
            c = this.next();
        }
        return c;
    }

    char skipHexadecimalDigit() {
        char c = this.peek();
        while (CharTable.isHexadecimalDigit(c)) {
            c = this.next();
        }
        return c;
    }

    char skipOctalDigit() {
        char c = this.peek();
        while (CharTable.isOctalDigit(c)) {
            c = this.next();
        }
        return c;
    }

    boolean fail() {
        this.forward = this.lexemeBegin;
        this.forwardRow = this.beginRow;
        if (this.state < 100) {
            this.state = 100;
        } else if (this.state < 200) {
            this.state = 200;
        } else if (this.state < 300) {
            this.state = 300;
        }
        return false;
    }

    char next() {
        if (this.buf[this.forward] == '\n') {
            ++this.forwardRow;
        }
        return this.buf[++this.forward];
    }

    char peek() {
        return this.buf[this.forward];
    }

    void skipBlanks() {
        while (CharTable.isBlankOrLineFeed(this.buf[this.forward])) {
            this.next();
        }
    }

    StringBuilder subBuf(int start, int end) {
        if (start > end) {
            return null;
        }
        StringBuilder ret = new StringBuilder(end - start + 1);
        for (int i = start; i <= end; ++i) {
            ret.append(this.buf[i]);
        }
        return ret;
    }

    boolean prepareNextScan() {
        this.state = 0;
        this.lexemeBegin = this.forward;
        this.beginRow = this.forwardRow;
        return true;
    }

    void addToken(Tok tok) {
        this.tokens.add(tok);
    }

    void retract(int n) {
        for (int i = 0; i < n; ++i) {
            --this.forward;
            if (this.buf[this.forward] != '\n') continue;
            --this.forwardRow;
        }
    }
}

