/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.beetl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.FileResourceLoader;
import org.beetl.core.statement.ErrorGrammarProgram;
import org.beetl.core.tag.Tag;
import org.beetl.core.tag.TagFactory;
import org.noear.solon.Solon;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.web.DebugUtils;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.SupplierEx;
import org.noear.solon.view.ViewConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeetlRender
implements Render {
    static final Logger log = LoggerFactory.getLogger(BeetlRender.class);
    private static BeetlRender _global;
    private final ClassLoader classLoader;
    private final String viewPrefix;
    private Configuration config = null;
    private GroupTemplate provider = null;
    private GroupTemplate providerOfDebug = null;

    public static BeetlRender global() {
        if (_global == null) {
            _global = new BeetlRender();
        }
        return _global;
    }

    public GroupTemplate getProvider() {
        return this.provider;
    }

    public GroupTemplate getProviderOfDebug() {
        return this.providerOfDebug;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public BeetlRender() {
        this((ClassLoader)AppClassLoader.global(), null);
    }

    public BeetlRender(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public BeetlRender(ClassLoader classLoader, String viewPrefix) {
        this.classLoader = classLoader;
        this.viewPrefix = viewPrefix == null ? ViewConfig.getViewPrefix() : viewPrefix;
        try {
            this.config = Configuration.defaultConfiguration();
            this.config.setCharset(ServerProps.response_encoding);
            this.config.setNativeCall(true);
            this.config.setNativeSecurity("org.beetl.core.DefaultNativeSecurityManager");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.forDebug();
        this.forRelease();
        Solon.app().shared().forEach((k, v) -> this.putVariable((String)k, v));
        Solon.app().onSharedAdd((k, v) -> this.putVariable((String)k, v));
    }

    private void forDebug() {
        if (!Solon.cfg().isDebugMode()) {
            return;
        }
        if (!Solon.cfg().isFilesMode()) {
            return;
        }
        if (this.providerOfDebug != null) {
            return;
        }
        File dir = DebugUtils.getDebugLocation((ClassLoader)this.classLoader, (String)this.viewPrefix);
        if (dir == null) {
            return;
        }
        try {
            if (dir.exists()) {
                FileResourceLoader loader = new FileResourceLoader(dir.getPath(), Solon.encoding());
                loader.setAutoCheck(true);
                this.providerOfDebug = new GroupTemplate((ResourceLoader)loader, this.config);
                EventBus.publish((Object)this.providerOfDebug);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void forRelease() {
        if (this.provider != null) {
            return;
        }
        try {
            if (ResourceUtil.hasFile((String)this.viewPrefix)) {
                URL dir = ResourceUtil.findResource((ClassLoader)this.classLoader, (String)this.viewPrefix, (boolean)false);
                FileResourceLoader loader = new FileResourceLoader(dir.getFile(), Solon.encoding());
                this.providerOfDebug = new GroupTemplate((ResourceLoader)loader, this.config);
            } else {
                ClasspathResourceLoader loader = new ClasspathResourceLoader(this.classLoader, this.viewPrefix);
                this.provider = new GroupTemplate((ResourceLoader)loader, this.config);
            }
            EventBus.publish((Object)this.provider);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void putDirective(String name, Class<? extends Tag> clz) {
        try {
            this.provider.registerTag(name, clz);
            if (this.providerOfDebug != null) {
                this.providerOfDebug.registerTag(name, clz);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void putDirective(String name, TagFactory tagFactory) {
        try {
            this.provider.registerTagFactory(name, tagFactory);
            if (this.providerOfDebug != null) {
                this.providerOfDebug.registerTagFactory(name, tagFactory);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void putVariable(String name, Object value) {
        try {
            this.provider.getSharedVars().put(name, value);
            if (this.providerOfDebug != null) {
                this.providerOfDebug.getSharedVars().put(name, value);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void render(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> ctx.outputStream()));
        } else {
            ctx.output(obj.toString());
        }
    }

    public String renderAndReturn(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ModelAndView) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> outputStream));
            return outputStream.toString();
        }
        return obj.toString();
    }

    private void render_mav(ModelAndView mv, Context ctx, SupplierEx<OutputStream> outputStream) throws Throwable {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=utf-8");
        }
        if (ViewConfig.isOutputMeta()) {
            ctx.headerSet("Solon-View", "BeetlRender");
        }
        mv.putIfAbsent("context", (Object)ctx);
        Template template = null;
        if (this.providerOfDebug != null) {
            try {
                template = this.providerOfDebug.getTemplate((Object)mv.view());
                if (template != null && template.program instanceof ErrorGrammarProgram) {
                    template = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (template == null) {
            template = this.provider.getTemplate((Object)mv.view());
        }
        template.binding(mv.model());
        template.renderTo((OutputStream)outputStream.get());
    }
}

