/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.beetl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.net.URI;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.FileResourceLoader;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.ModelAndView;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XRender;

public class BeetlRender
implements XRender {
    Configuration cfg = null;
    GroupTemplate gt = null;
    private String _baseUri = "/WEB-INF/view/";

    public BeetlRender() {
        try {
            this.cfg = Configuration.defaultConfiguration();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String baseUri = XApp.global().prop().get("slon.mvc.view.prefix");
        if (!XUtil.isEmpty((String)baseUri)) {
            this._baseUri = baseUri;
        }
        if (XApp.global().prop().argx().getInt("debug") == 0) {
            this.initForRuntime();
        } else {
            String dirroot = XUtil.getResource((String)"/").toString().replace("target/classes/", "");
            String dir_str = dirroot + "src/main/resources" + this._baseUri;
            File dir = new File(URI.create(dir_str));
            if (!dir.exists()) {
                dir_str = dirroot + "src/main/webapp" + this._baseUri;
                dir = new File(URI.create(dir_str));
            }
            try {
                if (dir.exists()) {
                    FileResourceLoader loader = new FileResourceLoader(dir.getAbsolutePath(), "utf-8");
                    this.gt = new GroupTemplate(loader, this.cfg);
                } else {
                    this.initForRuntime();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void initForRuntime() {
        try {
            ClasspathResourceLoader loader = new ClasspathResourceLoader(this.getClass().getClassLoader(), this._baseUri);
            this.gt = new GroupTemplate(loader, this.cfg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void registerTag(String name, Class<?> tag) {
        try {
            this.gt.registerTag(name, tag);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setSharedVariable(String name, Object value) {
        try {
            this.gt.getSharedVars().put(name, value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void render(Object obj, XContext ctx) throws Exception {
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx);
        } else {
            this.render_obj(obj, ctx);
        }
    }

    private void render_obj(Object obj, XContext ctx) throws Exception {
        boolean is_rpc = "service".equals(ctx.attr("solon.reader.source", null));
        if (!is_rpc) {
            if (obj instanceof String) {
                ctx.output((String)obj);
                return;
            }
            if (obj instanceof Exception) {
                throw (Exception)obj;
            }
        }
        String txt = null;
        txt = is_rpc ? JSON.toJSONString(obj, SerializerFeature.BrowserCompatible, SerializerFeature.WriteClassName, SerializerFeature.DisableCircularReferenceDetect) : JSON.toJSONString(obj, SerializerFeature.BrowserCompatible, SerializerFeature.DisableCircularReferenceDetect);
        ctx.outputAsJson(txt);
    }

    public void render_mav(ModelAndView mv, XContext cxt) throws Exception {
        if (XUtil.isEmpty((String)mv.view())) {
            this.render_obj(mv, cxt);
            return;
        }
        cxt.contentType("text/html;charset=utf-8");
        Template template = this.gt.getTemplate(mv.view(), "utf-8");
        template.binding(mv.model());
        template.renderTo(cxt.outputStream());
    }
}

