/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.IVarIndex;
import org.beetl.core.statement.Statement;
import org.beetl.core.statement.Type;

public class VarAssignStatement
extends Statement
implements IVarIndex {
    protected int varIndex;
    public Expression exp;

    public VarAssignStatement(Expression exp, GrammarToken token) {
        super(token);
        this.exp = exp;
    }

    @Override
    public void execute(Context ctx) {
        ctx.vars[this.varIndex] = this.exp.evaluate(ctx);
    }

    @Override
    public int getVarIndex() {
        return this.varIndex;
    }

    @Override
    public void setVarIndex(int varIndex) {
        this.varIndex = varIndex;
    }

    @Override
    public void infer(InferContext inferCtx) {
        this.exp.infer(inferCtx);
        Type oldType = inferCtx.types[this.varIndex];
        Type newType = this.exp.type;
        inferCtx.types[this.varIndex] = oldType == null ? newType : (oldType.cls == Type.NULLType.cls ? newType : newType);
    }
}

