/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.vault.integration;

import java.lang.reflect.Type;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.util.ConvertUtil;
import org.noear.solon.vault.VaultUtils;
import org.noear.solon.vault.annotation.VaultInject;

public class VaultBeanInjector
implements BeanInjector<VaultInject> {
    public void doInject(VarHolder varH, VaultInject anno) {
        this.beanInject(varH, anno.value(), anno.autoRefreshed());
    }

    protected void beanInject(VarHolder varH, String name, boolean autoRefreshed) {
        if (name.startsWith("${")) {
            String name2 = name.substring(2, name.length() - 1).trim();
            this.beanInjectConfig(varH, name2);
            if (autoRefreshed && varH.isField()) {
                varH.context().cfg().onChange((key, val) -> {
                    if (key.startsWith(name2)) {
                        this.beanInjectConfig(varH, name2);
                    }
                });
            }
        }
    }

    private void beanInjectConfig(VarHolder varH, String name) {
        if (Properties.class == varH.getType()) {
            Object val = varH.context().cfg().getProp(name);
            val = this.guardDo((Properties)val);
            varH.setValue(val);
        } else {
            String def = null;
            int defIdx = name.indexOf(":");
            if (defIdx > 0) {
                def = name.length() > defIdx + 1 ? name.substring(defIdx + 1).trim() : "";
                name = name.substring(0, defIdx).trim();
            }
            String val = varH.context().cfg().get(name);
            if (def != null && Utils.isEmpty((String)val)) {
                val = def;
            }
            if ((val = this.guardDo(val)) == null) {
                Object val0;
                Class pt = varH.getType();
                if (!pt.getName().startsWith("java.lang.") && !pt.isPrimitive() && (val0 = varH.context().cfg().getProp(name)).size() > 0) {
                    val0 = this.guardDo((Properties)val0);
                    Object val2 = PropsConverter.global().convert((Properties)val0, null, pt, (Type)varH.getGenericType());
                    varH.setValue(val2);
                }
            } else {
                Object val2 = ConvertUtil.to((Class)varH.getType(), (String)val);
                varH.setValue(val2);
            }
        }
    }

    private String guardDo(String str) {
        if (VaultUtils.isEncrypted(str)) {
            return VaultUtils.decrypt(str);
        }
        return str;
    }

    private Properties guardDo(Properties props) {
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String val;
            if (v instanceof String && VaultUtils.isEncrypted(val = (String)v)) {
                String val2 = VaultUtils.decrypt(val);
                props.put(k, val2);
            }
        }));
        return props;
    }
}

