/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.Numeric;
import org.noear.solon.validation.util.StringUtils;

public class NumericValidator
implements Validator<Numeric> {
    public static final NumericValidator instance = new NumericValidator();

    @Override
    public String message(Numeric anno) {
        return anno.message();
    }

    @Override
    public Result validateOfValue(String label, Numeric anno, Object val0, StringBuilder tmp) {
        if (val0 != null && !(val0 instanceof String)) {
            return Result.failure((String)label);
        }
        String val = (String)val0;
        if (!this.verify(anno, val)) {
            return Result.failure((String)label);
        }
        return Result.succeed();
    }

    @Override
    public Result validateOfContext(Context ctx, Numeric anno, String name, StringBuilder tmp) {
        if (name == null) {
            for (String key : anno.value()) {
                String val = ctx.param(key);
                if (this.verify(anno, val)) continue;
                tmp.append(',').append(key);
            }
        } else {
            String val = ctx.param(name);
            if (!this.verify(anno, val)) {
                tmp.append(',').append(name);
            }
        }
        if (tmp.length() > 1) {
            return Result.failure((String)tmp.substring(1));
        }
        return Result.succeed();
    }

    private boolean verify(Numeric anno, String val) {
        if (Utils.isEmpty((String)val)) {
            return true;
        }
        return StringUtils.isNumber(val);
    }
}

