/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import java.time.format.DateTimeFormatter;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.Date;

public class DateValidator
implements Validator<Date> {
    public static final DateValidator instance = new DateValidator();

    @Override
    public String message(Date anno) {
        return anno.message();
    }

    @Override
    public Result validateOfValue(String label, Date anno, Object val0, StringBuilder tmp) {
        if (val0 != null && !(val0 instanceof String)) {
            return Result.failure((String)label);
        }
        String val = (String)val0;
        if (!this.verify(anno, val)) {
            return Result.failure((String)label);
        }
        return Result.succeed();
    }

    @Override
    public Result validateOfContext(Context ctx, Date anno, String name, StringBuilder tmp) {
        String val = ctx.param(name);
        if (!this.verify(anno, val)) {
            return Result.failure((String)name);
        }
        return Result.succeed();
    }

    private boolean verify(Date anno, String val) {
        if (Utils.isEmpty((String)val)) {
            return true;
        }
        try {
            if (Utils.isEmpty((String)anno.value())) {
                DateTimeFormatter.ISO_LOCAL_DATE_TIME.parse(val);
            } else {
                DateTimeFormatter.ofPattern(anno.value()).parse(val);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

