/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.Pattern;

public class PatternValidator
implements Validator<Pattern> {
    private static final Map<String, java.util.regex.Pattern> cached = new ConcurrentHashMap<String, java.util.regex.Pattern>();
    public static final PatternValidator instance = new PatternValidator();

    @Override
    public String message(Pattern anno) {
        return anno.message();
    }

    @Override
    public Result validateOfEntity(Class<?> clz, Pattern anno, String name, Object val0, StringBuilder tmp) {
        if (!(val0 instanceof String)) {
            return Result.failure((String)(clz.getSimpleName() + "." + name));
        }
        String val = (String)val0;
        if (!this.verify(anno, val)) {
            return Result.failure((String)(clz.getSimpleName() + "." + name));
        }
        return Result.succeed();
    }

    @Override
    public Result validateOfContext(Context ctx, Pattern anno, String name, StringBuilder tmp) {
        String val = ctx.param(name);
        if (!this.verify(anno, val)) {
            return Result.failure((String)name);
        }
        return Result.succeed();
    }

    private boolean verify(Pattern anno, String val) {
        if (anno.orEmpty() && Utils.isEmpty((String)val)) {
            return true;
        }
        if (val == null) {
            return false;
        }
        java.util.regex.Pattern pt = cached.get(anno.value());
        if (pt == null) {
            pt = java.util.regex.Pattern.compile(anno.value());
            cached.putIfAbsent(anno.value(), pt);
        }
        return pt.matcher(val).find();
    }
}

