/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.sessionstate.redisson;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.noear.solon.Utils;
import org.noear.solon.boot.web.SessionStateBase;
import org.noear.solon.core.handle.Context;
import org.noear.solon.sessionstate.redisson.RedissonSessionStateFactory;
import org.noear.solon.sessionstate.redisson.SessionProp;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;

public class RedissonSessionState
extends SessionStateBase {
    private static int _expiry = 7200;
    private static String _domain = null;
    private Context ctx;
    private RedissonClient redisClient;

    protected RedissonSessionState(Context ctx) {
        this.ctx = ctx;
        this.redisClient = RedissonSessionStateFactory.getInstance().redisClient();
    }

    protected String cookieGet(String key) {
        return this.ctx.cookie(key);
    }

    protected void cookieSet(String key, String val) {
        if (SessionProp.session_state_domain_auto && _domain != null && this.ctx.uri().getHost().indexOf(_domain) < 0) {
            this.ctx.cookieSet(key, val, null, _expiry);
            return;
        }
        this.ctx.cookieSet(key, val, _domain, _expiry);
    }

    public String sessionId() {
        String _sessionId = (String)this.ctx.attr("sessionId", null);
        if (_sessionId == null) {
            _sessionId = this.sessionIdGet(false);
            this.ctx.attrSet("sessionId", (Object)_sessionId);
        }
        return _sessionId;
    }

    public String sessionChangeId() {
        this.sessionIdGet(true);
        this.ctx.attrSet("sessionId", null);
        return this.sessionId();
    }

    public Collection<String> sessionKeys() {
        RMapCache hash = this.redisClient.getMapCache(this.sessionId());
        return hash.keySet();
    }

    public Object sessionGet(String key) {
        RMapCache hash = this.redisClient.getMapCache(this.sessionId());
        return hash.get((Object)key);
    }

    public void sessionSet(String key, Object val) {
        if (val == null) {
            this.sessionRemove(key);
        } else {
            RMapCache hash = this.redisClient.getMapCache(this.sessionId());
            hash.put((Object)key, val, (long)_expiry, TimeUnit.SECONDS);
        }
    }

    public void sessionRemove(String key) {
        RMapCache hash = this.redisClient.getMapCache(this.sessionId());
        hash.remove((Object)key);
    }

    public void sessionClear() {
        this.redisClient.getMapCache(this.sessionId()).delete();
    }

    public void sessionReset() {
        this.sessionClear();
        this.sessionChangeId();
    }

    public void sessionRefresh() {
        String sid = this.sessionIdPush();
        if (!Utils.isEmpty((String)sid)) {
            RMapCache hash = this.redisClient.getMapCache(this.sessionId());
            hash.expire((long)_expiry, TimeUnit.SECONDS);
        }
    }

    public boolean replaceable() {
        return false;
    }

    static {
        if (SessionProp.session_timeout > 0) {
            _expiry = SessionProp.session_timeout;
        }
        if (SessionProp.session_state_domain != null) {
            _domain = SessionProp.session_state_domain;
        }
    }
}

