/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.sessionstate.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.impl.DefaultClaims;
import java.util.Collection;
import java.util.ServiceConfigurationError;
import org.noear.solon.Utils;
import org.noear.solon.boot.web.SessionStateBase;
import org.noear.solon.core.handle.Context;
import org.noear.solon.sessionstate.jwt.JwtUtils;
import org.noear.solon.sessionstate.jwt.SessionProp;

public class JwtSessionState
extends SessionStateBase {
    private Claims sessionMap;
    private String sessionToken;

    protected JwtSessionState(Context ctx) {
        super(ctx);
    }

    public String sessionId() {
        if (SessionProp.session_jwt_allowUseHeader) {
            return "";
        }
        String _sessionId = (String)this.ctx.attr("sessionId", null);
        if (_sessionId == null) {
            _sessionId = this.sessionIdGet(false);
            this.ctx.attrSet("sessionId", (Object)_sessionId);
        }
        return _sessionId;
    }

    public String sessionChangeId() {
        this.sessionIdGet(true);
        this.ctx.attrSet("sessionId", null);
        return this.sessionId();
    }

    public Collection<String> sessionKeys() {
        return this.sessionMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Claims sessionMap() {
        if (this.sessionMap == null) {
            JwtSessionState jwtSessionState = this;
            synchronized (jwtSessionState) {
                if (this.sessionMap == null) {
                    Claims claims;
                    this.sessionMap = new DefaultClaims();
                    String sesId = this.sessionId();
                    String token = this.jwtGet();
                    if (Utils.isNotEmpty((String)token) && token.contains(".") && (claims = JwtUtils.parseJwt(token)) != null && (SessionProp.session_jwt_allowUseHeader || sesId.equals(claims.getId()))) {
                        if (SessionProp.session_jwt_allowExpire) {
                            if (claims.getExpiration() != null && claims.getExpiration().getTime() > System.currentTimeMillis()) {
                                this.sessionMap = claims;
                            }
                        } else {
                            this.sessionMap = claims;
                        }
                    }
                    this.sessionToken = null;
                }
            }
        }
        return this.sessionMap;
    }

    public Object sessionGet(String key) {
        return this.sessionMap().get((Object)key);
    }

    public void sessionSet(String key, Object val) {
        if (val == null) {
            this.sessionRemove(key);
        } else {
            this.sessionMap().put((Object)key, val);
            this.sessionToken = null;
        }
    }

    public void sessionRemove(String key) {
        this.sessionMap().remove((Object)key);
        this.sessionToken = null;
    }

    public void sessionClear() {
        this.sessionMap().clear();
        this.sessionToken = null;
    }

    public void sessionReset() {
        this.sessionClear();
        this.sessionChangeId();
    }

    public void sessionRefresh() {
        if (SessionProp.session_jwt_allowUseHeader) {
            return;
        }
        this.sessionIdPush();
    }

    public void sessionPublish() {
        String token;
        if (SessionProp.session_jwt_allowAutoIssue && Utils.isNotEmpty((String)(token = this.sessionToken()))) {
            this.jwtSet(token);
        }
    }

    public String sessionToken() {
        Claims tmp;
        if (this.sessionToken == null && (tmp = this.sessionMap()) != null) {
            if (SessionProp.session_jwt_allowUseHeader && tmp.size() == 0) {
                this.sessionToken = "";
            }
            if (this.sessionToken == null) {
                String skey = this.sessionId();
                if (SessionProp.session_jwt_allowUseHeader || Utils.isNotEmpty((String)skey)) {
                    tmp.setId(skey);
                    try {
                        this.sessionToken = SessionProp.session_jwt_allowExpire ? JwtUtils.buildJwt(tmp, (long)_expiry * 1000L) : JwtUtils.buildJwt(tmp, 0L);
                    }
                    catch (ServiceConfigurationError e) {
                        this.sessionToken = "";
                    }
                }
            }
        }
        return this.sessionToken;
    }

    public boolean replaceable() {
        return false;
    }

    protected String jwtGet() {
        if (SessionProp.session_jwt_allowUseHeader) {
            return this.ctx.header(SessionProp.session_jwt_name);
        }
        return this.cookieGet(SessionProp.session_jwt_name);
    }

    protected void jwtSet(String token) {
        if (SessionProp.session_jwt_allowUseHeader) {
            this.ctx.headerSet(SessionProp.session_jwt_name, token);
        } else {
            this.cookieSet(SessionProp.session_jwt_name, token);
        }
        this.ctx.attrSet(SessionProp.session_jwt_name, (Object)token);
    }
}

