/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.sessionstate.jedis;

import java.util.Collection;
import org.noear.redisx.RedisClient;
import org.noear.solon.Utils;
import org.noear.solon.boot.web.SessionStateBase;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.serialize.Serializer;
import org.noear.solon.sessionstate.jedis.JavabinSerializer;
import org.noear.solon.sessionstate.jedis.JedisSessionStateFactory;

public class JedisSessionState
extends SessionStateBase {
    private RedisClient redisClient;
    private Serializer<String> serializer = JavabinSerializer.instance;

    protected JedisSessionState(Context ctx) {
        super(ctx);
        this.redisClient = JedisSessionStateFactory.getInstance().redisClient();
    }

    public String sessionId() {
        String _sessionId = (String)this.ctx.attr("sessionId", null);
        if (_sessionId == null) {
            _sessionId = this.sessionIdGet(false);
            this.ctx.attrSet("sessionId", (Object)_sessionId);
        }
        return _sessionId;
    }

    public String sessionChangeId() {
        this.sessionIdGet(true);
        this.ctx.attrSet("sessionId", null);
        return this.sessionId();
    }

    public Collection<String> sessionKeys() {
        return (Collection)this.redisClient.openAndGet(ru -> ru.key(this.sessionId()).hashGetAllKeys());
    }

    public <T> T sessionGet(String key, Class<T> clz) {
        String val = (String)this.redisClient.openAndGet(ru -> ru.key(this.sessionId()).expire(_expiry).hashGet(key));
        if (val == null) {
            return null;
        }
        try {
            return (T)this.serializer.deserialize((Object)val, clz);
        }
        catch (Exception e) {
            throw new RuntimeException("Session state deserialization error: " + key + " = " + val, e);
        }
    }

    public void sessionSet(String key, Object val) {
        if (val == null) {
            this.sessionRemove(key);
        } else {
            try {
                String json = (String)this.serializer.serialize(val);
                this.redisClient.open(ru -> ru.key(this.sessionId()).expire(_expiry).hashSet(key, json));
            }
            catch (Exception e) {
                throw new RuntimeException("Session state serialization error: " + key + " = " + val, e);
            }
        }
    }

    public void sessionRemove(String key) {
        this.redisClient.open(ru -> ru.key(this.sessionId()).expire(_expiry).hashDel(new String[]{key}));
    }

    public void sessionClear() {
        this.redisClient.open(ru -> ru.key(this.sessionId()).delete());
    }

    public void sessionReset() {
        this.sessionClear();
        this.sessionChangeId();
    }

    public void sessionRefresh() {
        String sid = this.sessionIdPush();
        if (!Utils.isEmpty((String)sid)) {
            this.redisClient.open(ru -> ru.key(this.sessionId()).expire(_expiry).delay());
        }
    }

    public boolean replaceable() {
        return false;
    }
}

