/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.sessionstate.jedis;

import java.util.Collection;
import org.noear.redisx.RedisClient;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerConstants;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.data.cache.Serializer;
import org.noear.solon.sessionstate.jedis.EncryptUtil;
import org.noear.solon.sessionstate.jedis.JavabinSerializer;
import org.noear.solon.sessionstate.jedis.JedisSessionStateFactory;
import org.noear.solon.sessionstate.jedis.SessionProp;

public class JedisSessionState
implements SessionState {
    private static int _expiry = 7200;
    private static String _domain = null;
    private Context ctx;
    private RedisClient redisClient;
    private Serializer<String> serializer;

    protected JedisSessionState(Context ctx) {
        this.ctx = ctx;
        this.serializer = JavabinSerializer.instance;
        this.redisClient = JedisSessionStateFactory.getInstance().redisClient();
    }

    public String cookieGet(String key) {
        return this.ctx.cookie(key);
    }

    public void cookieSet(String key, String val) {
        if (SessionProp.session_state_domain_auto && _domain != null && this.ctx.uri().getHost().indexOf(_domain) < 0) {
            this.ctx.cookieSet(key, val, null, _expiry);
            return;
        }
        this.ctx.cookieSet(key, val, _domain, _expiry);
    }

    public String sessionId() {
        String _sessionId = (String)this.ctx.attr("sessionId", null);
        if (_sessionId == null) {
            _sessionId = this.sessionIdGet(false);
            this.ctx.attrSet("sessionId", (Object)_sessionId);
        }
        return _sessionId;
    }

    public String sessionChangeId() {
        this.sessionIdGet(true);
        this.ctx.attrSet("sessionId", null);
        return this.sessionId();
    }

    public Collection<String> sessionKeys() {
        return (Collection)this.redisClient.openAndGet(ru -> ru.key(this.sessionId()).hashGetAllKeys());
    }

    private String sessionIdGet(boolean reset) {
        String skey = this.cookieGet("SOLONID");
        String smd5 = this.cookieGet(ServerConstants.SESSIONID_MD5());
        if (!reset && !Utils.isEmpty((String)skey) && !Utils.isEmpty((String)smd5) && Utils.md5((String)(skey + "&L8e!@T0")).equals(smd5)) {
            return skey;
        }
        skey = Utils.guid();
        this.cookieSet("SOLONID", skey);
        this.cookieSet(ServerConstants.SESSIONID_MD5(), Utils.md5((String)(skey + "&L8e!@T0")));
        return skey;
    }

    public Object sessionGet(String key) {
        String val = (String)this.redisClient.openAndGet(ru -> ru.key(this.sessionId()).expire(_expiry).hashGet(key));
        if (val == null) {
            return null;
        }
        try {
            return this.serializer.deserialize((Object)val);
        }
        catch (Exception e) {
            throw new RuntimeException("Session state deserialization error: " + key + " = " + val, e);
        }
    }

    public void sessionSet(String key, Object val) {
        if (val == null) {
            this.sessionRemove(key);
        } else {
            try {
                String json = (String)this.serializer.serialize(val);
                this.redisClient.open(ru -> ru.key(this.sessionId()).expire(_expiry).hashSet(key, json));
            }
            catch (Exception e) {
                throw new RuntimeException("Session state serialization error: " + key + " = " + val, e);
            }
        }
    }

    public void sessionRemove(String key) {
        this.redisClient.open(ru -> ru.key(this.sessionId()).expire(_expiry).hashDel(new String[]{key}));
    }

    public void sessionClear() {
        this.redisClient.open(ru -> ru.key(this.sessionId()).delete());
    }

    public void sessionReset() {
        this.sessionClear();
        this.sessionChangeId();
    }

    public void sessionRefresh() {
        String skey = this.cookieGet("SOLONID");
        if (!Utils.isEmpty((String)skey)) {
            this.cookieSet("SOLONID", skey);
            this.cookieSet(ServerConstants.SESSIONID_MD5(), EncryptUtil.md5(skey + "&L8e!@T0"));
            this.redisClient.open(ru -> ru.key(this.sessionId()).expire(_expiry).delay());
        }
    }

    public boolean replaceable() {
        return false;
    }

    static {
        if (SessionProp.session_timeout > 0) {
            _expiry = SessionProp.session_timeout;
        }
        if (SessionProp.session_state_domain != null) {
            _domain = SessionProp.session_state_domain;
        }
    }
}

