/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.sessionstate.jedis;

import java.util.Collection;
import org.noear.redisx.RedisClient;
import org.noear.snack.ONode;
import org.noear.snack.core.Feature;
import org.noear.snack.core.Options;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerConstants;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.sessionstate.jedis.EncryptUtil;
import org.noear.solon.sessionstate.jedis.RedisSessionStateFactory;
import org.noear.solon.sessionstate.jedis.SessionProp;

public class RedisSessionState
implements SessionState {
    private static int _expiry = 7200;
    private static String _domain = null;
    private Context ctx;
    private RedisClient redisClient;

    protected RedisSessionState(Context ctx) {
        this.ctx = ctx;
        this.redisClient = RedisSessionStateFactory.getInstance().redisClient();
    }

    public String cookieGet(String key) {
        return this.ctx.cookie(key);
    }

    public void cookieSet(String key, String val) {
        if (SessionProp.session_state_domain_auto && _domain != null && this.ctx.uri().getHost().indexOf(_domain) < 0) {
            this.ctx.cookieSet(key, val, null, _expiry);
            return;
        }
        this.ctx.cookieSet(key, val, _domain, _expiry);
    }

    public String sessionId() {
        String _sessionId = (String)this.ctx.attr("sessionId", null);
        if (_sessionId == null) {
            _sessionId = this.sessionIdGet(false);
            this.ctx.attrSet("sessionId", (Object)_sessionId);
        }
        return _sessionId;
    }

    public String sessionChangeId() {
        this.sessionIdGet(true);
        this.ctx.attrSet("sessionId", null);
        return this.sessionId();
    }

    public Collection<String> sessionKeys() {
        return (Collection)this.redisClient.openAndGet(ru -> ru.key(this.sessionId()).hashGetAllKeys());
    }

    private String sessionIdGet(boolean reset) {
        String skey = this.cookieGet("SOLONID");
        String smd5 = this.cookieGet(ServerConstants.SESSIONID_MD5());
        if (!reset && !Utils.isEmpty((String)skey) && !Utils.isEmpty((String)smd5) && Utils.md5((String)(skey + "&L8e!@T0")).equals(smd5)) {
            return skey;
        }
        skey = Utils.guid();
        this.cookieSet("SOLONID", skey);
        this.cookieSet(ServerConstants.SESSIONID_MD5(), Utils.md5((String)(skey + "&L8e!@T0")));
        return skey;
    }

    public Object sessionGet(String key) {
        String json = (String)this.redisClient.openAndGet(ru -> ru.key(this.sessionId()).expire(_expiry).hashGet(key));
        if (json == null) {
            return null;
        }
        ONode tmp = ONode.loadStr((String)json);
        String type = tmp.get("t").getString();
        ONode data = tmp.get("d");
        try {
            switch (type) {
                case "Null": {
                    return null;
                }
                case "Short": {
                    return data.val().getShort();
                }
                case "Integer": {
                    return data.val().getInt();
                }
                case "Long": {
                    return data.val().getLong();
                }
                case "Float": {
                    return Float.valueOf(data.val().getFloat());
                }
                case "Double": {
                    return data.val().getDouble();
                }
                case "Date": {
                    return data.val().getDate();
                }
                case "Boolean": {
                    return data.val().getBoolean();
                }
            }
            return data.toObject();
        }
        catch (Exception ex) {
            throw new RuntimeException("Session state deserialization error: " + key + " = " + json);
        }
    }

    public void sessionSet(String key, Object val) {
        if (val == null) {
            this.sessionRemove(key);
        } else {
            ONode tmp = new ONode();
            try {
                tmp.set("t", (Object)val.getClass().getSimpleName());
                tmp.set("d", (Object)ONode.loadObj((Object)val, (Options)Options.serialize().remove(new Feature[]{Feature.BrowserCompatible})));
            }
            catch (Exception ex) {
                throw new RuntimeException("Session state serialization error: " + key + " = " + val);
            }
            String json = tmp.toJson();
            this.redisClient.open(ru -> ru.key(this.sessionId()).expire(_expiry).hashSet(key, json));
        }
    }

    public void sessionRemove(String key) {
        this.redisClient.open(ru -> ru.key(this.sessionId()).expire(_expiry).hashDel(new String[]{key}));
    }

    public void sessionClear() {
        this.redisClient.open(ru -> ru.key(this.sessionId()).delete());
    }

    public void sessionReset() {
        this.sessionClear();
        this.sessionChangeId();
    }

    public void sessionRefresh() {
        String skey = this.cookieGet("SOLONID");
        if (!Utils.isEmpty((String)skey)) {
            this.cookieSet("SOLONID", skey);
            this.cookieSet(ServerConstants.SESSIONID_MD5(), EncryptUtil.md5(skey + "&L8e!@T0"));
            this.redisClient.open(ru -> ru.key(this.sessionId()).expire(_expiry).delay());
        }
    }

    public boolean replaceable() {
        return false;
    }

    static {
        if (SessionProp.session_timeout > 0) {
            _expiry = SessionProp.session_timeout;
        }
        if (SessionProp.session_state_domain != null) {
            _domain = SessionProp.session_state_domain;
        }
    }
}

