/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization;

import java.util.Base64;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.serialize.Serializer;
import org.noear.solon.serialization.SerializationConfig;

public class BytesSerializerRender
implements Render {
    private Serializer<byte[]> serializer;
    private String contentType;

    public BytesSerializerRender(Serializer<byte[]> serializer, String contentType) {
        this.serializer = serializer;
        this.contentType = contentType;
    }

    public Serializer<byte[]> getSerializer() {
        return this.serializer;
    }

    public String getName() {
        return this.getClass().getSimpleName() + "#" + this.serializer.name();
    }

    public String renderAndReturn(Object data, Context ctx) throws Throwable {
        byte[] tmp = (byte[])this.serializer.serialize(data);
        return Base64.getEncoder().encodeToString(tmp);
    }

    public void render(Object obj, Context ctx) throws Throwable {
        if (SerializationConfig.isOutputMeta()) {
            ctx.headerAdd("solon.serialization", this.getName());
        }
        ctx.contentType(this.contentType);
        if (obj instanceof ModelAndView) {
            ctx.output((byte[])this.serializer.serialize((Object)((ModelAndView)obj).model()));
        } else {
            ctx.output((byte[])this.serializer.serialize(obj));
        }
    }
}

