/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.noear.solon.core.handle.Render;
import org.noear.solon.serialization.ContextSerializer;
import org.noear.solon.serialization.StringSerializerRender;
import org.noear.solon.serialization.jackson.JacksonRenderFactoryBase;
import org.noear.solon.serialization.jackson.JacksonStringSerializer;

public class JacksonRenderTypedFactory
extends JacksonRenderFactoryBase {
    ObjectMapper config = new ObjectMapper();

    public JacksonRenderTypedFactory() {
        this.config.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.config.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.config.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        this.config.activateDefaultTypingAsProperty(this.config.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, "@type");
        this.config.registerModule((Module)new JavaTimeModule());
    }

    public Render create() {
        this.registerModule();
        JacksonStringSerializer serializer = new JacksonStringSerializer();
        serializer.setConfig(this.config);
        return new StringSerializerRender(true, (ContextSerializer)serializer);
    }

    @Override
    public ObjectMapper config() {
        return this.config;
    }
}

