/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.serialization.ActionSerializer;

public class JacksonStringSerializer
implements ActionSerializer<String> {
    private ObjectMapper config;

    public ObjectMapper getConfig() {
        if (this.config == null) {
            this.config = new ObjectMapper();
        }
        return this.config;
    }

    public void setConfig(ObjectMapper config) {
        if (config != null) {
            this.config = config;
        }
    }

    public String name() {
        return "jackson-json";
    }

    public String serialize(Object obj) throws IOException {
        return this.getConfig().writeValueAsString(obj);
    }

    public Object deserialize(String data, Class<?> clz) throws IOException {
        if (clz == null) {
            return this.getConfig().readTree(data);
        }
        return this.getConfig().readValue(data, clz);
    }

    public Object deserializeBody(Context ctx) throws IOException {
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            return this.getConfig().readTree(data);
        }
        return null;
    }
}

