/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Collection;
import org.noear.solon.serialization.prop.JsonProps;

public class NullValueSerializer
extends JsonSerializer<Object> {
    private Class<?> type;
    private JsonProps jsonProps;

    public NullValueSerializer(JsonProps jsonProps, JavaType type) {
        this.jsonProps = jsonProps;
        this.type = type == null ? Object.class : type.getRawClass();
    }

    public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (o == null) {
            if (this.type != null) {
                if (this.jsonProps.nullStringAsEmpty && this.type == String.class) {
                    jsonGenerator.writeString("");
                    return;
                }
                if (this.jsonProps.nullBoolAsFalse && this.type == Boolean.class) {
                    jsonGenerator.writeBoolean(false);
                    return;
                }
                if (this.jsonProps.nullNumberAsZero && CharSequence.class.isAssignableFrom(this.type)) {
                    if (this.type == Long.class) {
                        jsonGenerator.writeNumber(0L);
                    } else if (this.type == Double.class) {
                        jsonGenerator.writeNumber(0.0);
                    } else if (this.type == Float.class) {
                        jsonGenerator.writeNumber(0.0f);
                    } else {
                        jsonGenerator.writeNumber(0);
                    }
                    return;
                }
                if (this.jsonProps.nullArrayAsEmpty && (Collection.class.isAssignableFrom(this.type) || this.type.isArray())) {
                    jsonGenerator.writeStartArray();
                    jsonGenerator.writeEndArray();
                    return;
                }
            }
            if (this.jsonProps.nullAsWriteable) {
                jsonGenerator.writeNull();
                return;
            }
        }
    }
}

