/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson.xml;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Collection;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.mvc.ActionExecuteHandlerDefault;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.jackson.xml.JacksonXmlStringSerializer;
import org.noear.solon.serialization.jackson.xml.impl.TypeReferenceImpl;

public class JacksonXmlActionExecutor
extends ActionExecuteHandlerDefault {
    private JacksonXmlStringSerializer serializer = new JacksonXmlStringSerializer();

    public XmlMapper config() {
        return this.serializer.getConfig();
    }

    public void config(XmlMapper xmlMapper) {
        this.serializer.setConfig(xmlMapper);
    }

    public JacksonXmlActionExecutor() {
        this.serializer.getConfig().enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.serializer.getConfig().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.serializer.getConfig().setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        this.serializer.getConfig().activateDefaultTypingAsProperty(this.serializer.getConfig().getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, "@type");
        this.serializer.getConfig().registerModule((Module)new JavaTimeModule());
        this.serializer.getConfig().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.serializer.getConfig().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.serializer.getConfig().configure(FromXmlParser.Feature.EMPTY_ELEMENT_AS_NULL, true);
        this.serializer.getConfig().configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, false);
    }

    public boolean matched(Context ctx, String ct) {
        return this.serializer.matched(ctx, ct);
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return this.serializer.deserializeFromBody(ctx);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, Object bodyObj) throws Exception {
        if (p.isRequiredPath() || p.isRequiredCookie() || p.isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (!p.isRequiredBody() && ctx.paramMap().containsKey((Object)p.getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        JsonNode tmp = (JsonNode)bodyObj;
        if (tmp.isObject()) {
            if (!p.isRequiredBody() && tmp.has(p.getName())) {
                JsonNode m1 = tmp.get(p.getName());
                return this.serializer.getConfig().readValue(this.serializer.getConfig().treeAsTokens((TreeNode)m1), new TypeReferenceImpl(p));
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyObj);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            return this.serializer.getConfig().readValue(this.serializer.getConfig().treeAsTokens((TreeNode)tmp), new TypeReferenceImpl(p));
        }
        if (tmp.isArray()) {
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            return this.serializer.getConfig().readValue(this.serializer.getConfig().treeAsTokens((TreeNode)tmp), new TypeReferenceImpl(p));
        }
        if (tmp.isValueNode()) {
            return this.serializer.getConfig().readValue(this.serializer.getConfig().treeAsTokens((TreeNode)tmp), new TypeReferenceImpl(p));
        }
        return null;
    }
}

