/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import java.util.Collection;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.ActionExecuteHandlerDefault;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;

public class FastjsonActionExecutor
extends ActionExecuteHandlerDefault {
    private static final String label = "/json";
    private final ParserConfig config = new ParserConfig();

    public ParserConfig config() {
        return this.config;
    }

    public boolean matched(Context ctx, String ct) {
        return ct != null && ct.contains(label);
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        String json = ctx.bodyNew();
        if (Utils.isNotEmpty((String)json)) {
            return JSON.parse((String)json, (ParserConfig)this.config);
        }
        return null;
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, Object bodyObj) throws Exception {
        if (!p.isRequiredBody() && ctx.paramMap().containsKey((Object)p.getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj instanceof JSONObject) {
            JSONObject tmp = (JSONObject)bodyObj;
            if (!p.isRequiredBody() && tmp.containsKey((Object)p.getName())) {
                if (p.isGenericType()) {
                    return tmp.getObject(p.getName(), p.getGenericType());
                }
                return tmp.getObject(p.getName(), pt);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyObj);
            }
            if (List.class.isAssignableFrom(p.getType())) {
                return null;
            }
            if (p.getType().isArray()) {
                return null;
            }
            if (p.isGenericType()) {
                return tmp.toJavaObject(p.getGenericType());
            }
            return tmp.toJavaObject(pt);
        }
        if (bodyObj instanceof JSONArray) {
            JSONArray tmp = (JSONArray)bodyObj;
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            if (p.isGenericType()) {
                return tmp.toJavaObject(p.getGenericType());
            }
            return tmp.toJavaObject(p.getType());
        }
        return bodyObj;
    }
}

