/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson;

import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeWriter;
import org.noear.solon.serialization.JsonConverter;
import org.noear.solon.serialization.JsonRenderFactory;

public abstract class FastjsonRenderFactoryBase
implements JsonRenderFactory {
    protected abstract SerializeConfig config();

    public <T> void addEncoder(Class<T> clz, ObjectSerializer encoder) {
        this.config().put(clz, encoder);
    }

    public <T> void addConvertor(Class<T> clz, JsonConverter<T> converter) {
        this.addEncoder(clz, (ser, obj, fieldName, fieldType, features) -> {
            Object val = converter.convert(obj);
            SerializeWriter out = ser.getWriter();
            if (val == null) {
                out.writeNull();
            } else if (val instanceof String) {
                out.writeString((String)val);
            } else if (val instanceof Number) {
                if (val instanceof Integer || val instanceof Long) {
                    out.writeLong(((Number)val).longValue());
                } else {
                    out.writeDouble(((Number)val).doubleValue(), false);
                }
            } else {
                throw new IllegalArgumentException("The result type of the converter is not supported: " + val.getClass().getName());
            }
        });
    }
}

