/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.simple.integration;

import java.lang.reflect.Method;
import org.noear.solon.Utils;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.scheduling.ScheduledAnno;
import org.noear.solon.scheduling.annotation.Scheduled;
import org.noear.solon.scheduling.simple.JobManager;
import org.noear.solon.scheduling.simple.integration.BeanRunnable;
import org.noear.solon.scheduling.simple.integration.MethodRunnable;
import org.noear.solon.scheduling.utils.ScheduledHelper;

public class ScheduledBeanBuilder
implements BeanBuilder<Scheduled>,
BeanExtractor<Scheduled> {
    private final AopContext context;

    public ScheduledBeanBuilder(AopContext context) {
        this.context = context;
    }

    public void doBuild(Class<?> clz, BeanWrap bw, Scheduled anno) throws Throwable {
        if (Runnable.class.isAssignableFrom(clz)) {
            ScheduledAnno warpper = new ScheduledAnno(anno);
            ScheduledHelper.configScheduled((ScheduledAnno)warpper);
            BeanRunnable job = new BeanRunnable(bw);
            String jobId = clz.getName();
            String name = Utils.annoAlias((String)anno.name(), (String)jobId);
            JobManager.add(name, (Scheduled)warpper, job);
        }
    }

    public void doExtract(BeanWrap bw, Method method, Scheduled anno) throws Throwable {
        if (method.getParameterCount() > 0) {
            throw new IllegalStateException("Scheduling local job not supports parameter!");
        }
        ScheduledAnno warpper = new ScheduledAnno(anno);
        ScheduledHelper.configScheduled((ScheduledAnno)warpper);
        MethodRunnable job = new MethodRunnable(bw, method);
        String jobId = bw.clz().getName() + "::" + method.getName();
        String name = Utils.annoAlias((String)warpper.name(), (String)jobId);
        JobManager.add(name, (Scheduled)warpper, job);
    }
}

