/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.simple;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.scheduling.annotation.Scheduled;
import org.noear.solon.scheduling.simple.JobHolder;

public class JobManager {
    private static Map<String, JobHolder> jobEntityMap = new HashMap<String, JobHolder>();
    private static boolean isStarted = false;

    public static void add(String name, Scheduled anno, Runnable runnable) {
        if (!anno.enable()) {
            return;
        }
        if (Utils.isEmpty((String)name)) {
            throw new IllegalArgumentException("The job name cannot be empty!");
        }
        JobManager.addDo(name, new JobHolder(name, anno, runnable));
    }

    private static void addDo(String name, JobHolder jobEntity) {
        jobEntityMap.putIfAbsent(name, jobEntity);
        if (isStarted) {
            jobEntity.start();
        }
    }

    public static int count() {
        return jobEntityMap.size();
    }

    public static void start() {
        for (JobHolder job : jobEntityMap.values()) {
            job.start();
        }
        isStarted = true;
    }

    public static void stop() {
        for (JobHolder job : jobEntityMap.values()) {
            job.cancel();
        }
        isStarted = false;
    }
}

