/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.simple.integration;

import java.lang.reflect.Method;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.scheduling.ScheduledAnno;
import org.noear.solon.scheduling.annotation.Scheduled;
import org.noear.solon.scheduling.simple.JobManager;
import org.noear.solon.scheduling.simple.integration.MethodRunnable;
import org.noear.solon.scheduling.utils.ScheduledHelper;

public class ScheduledBeanBuilder
implements BeanBuilder<Scheduled>,
BeanExtractor<Scheduled> {
    public void doBuild(Class<?> clz, BeanWrap bw, Scheduled anno) throws Throwable {
        if (Runnable.class.isAssignableFrom(clz)) {
            String name = anno.name();
            if (Utils.isEmpty((String)name)) {
                name = clz.getName();
            }
            ScheduledAnno warpper = new ScheduledAnno(anno);
            ScheduledHelper.configScheduled((ScheduledAnno)warpper);
            JobManager.add(name, (Scheduled)warpper, (Runnable)bw.raw());
        }
    }

    public void doExtract(BeanWrap bw, Method method, Scheduled anno) throws Throwable {
        if (method.getParameterCount() > 0) {
            throw new IllegalStateException("Scheduling local job not supports parameter!");
        }
        String name = anno.name();
        if (Utils.isEmpty((String)name)) {
            name = bw.clz().getName() + "::" + method.getName();
        }
        MethodRunnable runnable = new MethodRunnable(bw.raw(), method);
        ScheduledAnno warpper = new ScheduledAnno(anno);
        ScheduledHelper.configScheduled((ScheduledAnno)warpper);
        JobManager.add(name, (Scheduled)warpper, runnable);
    }
}

