/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.quartz;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.scheduling.annotation.Scheduled;
import org.noear.solon.scheduling.quartz.AbstractJob;
import org.noear.solon.scheduling.quartz.JobHolder;
import org.noear.solon.scheduling.quartz.QuartzProxy;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public final class JobManager {
    static Scheduler _scheduler = null;
    static Map<String, JobHolder> jobMap = new HashMap<String, JobHolder>();

    public static void setScheduler(Scheduler scheduler) {
        if (_scheduler == null) {
            _scheduler = scheduler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void tryInitScheduler() throws SchedulerException {
        if (_scheduler != null) return;
        Class<JobManager> clazz = JobManager.class;
        synchronized (JobManager.class) {
            if (_scheduler != null) return;
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            _scheduler = schedulerFactory.getScheduler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void start() throws SchedulerException {
        JobManager.tryInitScheduler();
        for (JobHolder jobEntity : jobMap.values()) {
            JobManager.regJob(jobEntity);
        }
        if (_scheduler != null) {
            _scheduler.start();
        }
    }

    public static void stop() throws SchedulerException {
        if (_scheduler != null) {
            _scheduler.shutdown();
            _scheduler = null;
        }
    }

    public static void addJob(String name, Scheduled anno, AbstractJob job) throws Exception {
        if (!anno.enable()) {
            return;
        }
        if (Utils.isEmpty((String)name)) {
            throw new IllegalArgumentException("The job name cannot be empty!");
        }
        if (anno.initialDelay() > 0L) {
            throw new IllegalArgumentException("The quartz job unsupported initialDelay!");
        }
        if (anno.fixedDelay() > 0L) {
            throw new IllegalArgumentException("The quartz job unsupported fixedDelay!");
        }
        if (!jobMap.containsKey(name)) {
            JobHolder jobHolder = new JobHolder(name, anno, job);
            jobMap.put(name, jobHolder);
        }
    }

    public static JobHolder getJob(String name) {
        if (Utils.isEmpty((String)name)) {
            return null;
        }
        return jobMap.get(name);
    }

    private static void regJob(JobHolder jobHolder) throws SchedulerException {
        String jobGroup = Utils.annoAlias((String)Solon.cfg().appName(), (String)"solon");
        if (Utils.isEmpty((String)jobHolder.anno.cron())) {
            JobManager.regJobByFixedRate(jobHolder, jobHolder.anno.fixedRate(), jobGroup);
        } else {
            JobManager.regJobByCron(jobHolder, jobHolder.anno.cron(), jobGroup);
        }
    }

    private static void regJobByCron(JobHolder jobHolder, String cron, String jobGroup) throws SchedulerException {
        JobManager.tryInitScheduler();
        JobDetail jobDetail = JobBuilder.newJob(QuartzProxy.class).withIdentity(jobHolder.name, jobGroup).build();
        if (!_scheduler.checkExists(jobDetail.getKey())) {
            CronScheduleBuilder builder = CronScheduleBuilder.cronSchedule((String)cron);
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobHolder.name, jobGroup).startNow().withSchedule((ScheduleBuilder)builder).build();
            _scheduler.scheduleJob(jobDetail, trigger);
        }
    }

    private static void regJobByFixedRate(JobHolder jobHolder, long milliseconds, String jobGroup) throws SchedulerException {
        JobManager.tryInitScheduler();
        JobDetail jobDetail = JobBuilder.newJob(QuartzProxy.class).withIdentity(jobHolder.name, jobGroup).build();
        if (!_scheduler.checkExists(jobDetail.getKey())) {
            SimpleScheduleBuilder builder = SimpleScheduleBuilder.simpleSchedule();
            builder.withIntervalInMilliseconds(milliseconds);
            builder.repeatForever();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobHolder.name, jobGroup).startNow().withSchedule((ScheduleBuilder)builder).build();
            _scheduler.scheduleJob(jobDetail, trigger);
        }
    }
}

