/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.Utils;
import org.noear.solon.net.websocket.Handshake;
import org.noear.solon.net.websocket.HandshakeImpl;
import org.noear.solon.net.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebSocketBase
implements WebSocket {
    static final Logger log = LoggerFactory.getLogger(WebSocketBase.class);
    private final Map<String, Object> attrMap = new HashMap<String, Object>();
    private Handshake handshake;
    private boolean isClosed;
    private String pathNew;
    private String id = Utils.guid();

    protected void init(URI uri) {
        this.handshake = new HandshakeImpl(uri);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String url() {
        return this.handshake.getUrl();
    }

    @Override
    public String path() {
        if (this.pathNew == null) {
            return this.handshake.getUri().getPath();
        }
        return this.pathNew;
    }

    @Override
    public void pathNew(String pathNew) {
        this.pathNew = pathNew;
    }

    @Override
    public Map<String, String> paramMap() {
        return this.handshake.getParamMap();
    }

    @Override
    public String param(String name) {
        return this.handshake.getParamMap().get(name);
    }

    @Override
    public String paramOrDefault(String name, String def) {
        return this.handshake.getParamMap().getOrDefault(name, def);
    }

    @Override
    public void param(String name, String value) {
        this.handshake.getParamMap().put(name, value);
    }

    @Override
    public Map<String, Object> attrMap() {
        return this.attrMap;
    }

    @Override
    public boolean attrHas(String name) {
        return this.attrMap.containsKey(name);
    }

    @Override
    public <T> T attr(String name) {
        return (T)this.attrMap.get(name);
    }

    @Override
    public <T> T attrOrDefault(String name, T def) {
        return (T)this.attrMap.getOrDefault(name, def);
    }

    @Override
    public <T> void attr(String name, T value) {
        this.attrMap.put(name, value);
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketBase that = (WebSocketBase)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

