/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket.listener;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.LinkedList;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketListener;

public class PipelineWebSocketListener
implements WebSocketListener {
    protected final Deque<WebSocketListener> deque = new LinkedList<WebSocketListener>();

    public PipelineWebSocketListener prev(WebSocketListener listener) {
        this.deque.addFirst(listener);
        return this;
    }

    public PipelineWebSocketListener next(WebSocketListener listener) {
        this.deque.addLast(listener);
        return this;
    }

    @Override
    public void onOpen(WebSocket socket) {
        for (WebSocketListener listener : this.deque) {
            listener.onOpen(socket);
        }
    }

    @Override
    public void onMessage(WebSocket socket, String text) throws IOException {
        for (WebSocketListener listener : this.deque) {
            listener.onMessage(socket, text);
        }
    }

    @Override
    public void onMessage(WebSocket socket, ByteBuffer binary) throws IOException {
        for (WebSocketListener listener : this.deque) {
            listener.onMessage(socket, binary);
        }
    }

    @Override
    public void onClose(WebSocket socket) {
        for (WebSocketListener listener : this.deque) {
            listener.onClose(socket);
        }
    }

    @Override
    public void onError(WebSocket socket, Throwable error) {
        for (WebSocketListener listener : this.deque) {
            listener.onError(socket, error);
        }
    }
}

