/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.logging.appender;

import java.io.PrintWriter;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.snack.ONode;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.logging.appender.AppenderSimple;
import org.noear.solon.logging.event.Level;
import org.noear.solon.logging.event.LogEvent;

public abstract class OutputStreamAppender
extends AppenderSimple {
    protected PrintWriter out = null;
    protected final ReentrantLock SYNC_LOCK = new ReentrantLock(true);

    protected void setOutput(PrintWriter writer) {
        if (writer == null) {
            return;
        }
        PrintWriter outOld = this.out;
        this.out = writer;
        if (outOld != null) {
            outOld.flush();
            outOld.close();
        }
    }

    @Override
    public void append(LogEvent logEvent) {
        if (this.out == null) {
            return;
        }
        super.append(logEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void appendDo(Level level, String title, Object content) {
        this.SYNC_LOCK.lock();
        try {
            switch (level) {
                case ERROR: {
                    PrintUtil.redln((Object)title);
                    break;
                }
                case WARN: {
                    PrintUtil.yellowln((Object)title);
                    break;
                }
                case DEBUG: {
                    PrintUtil.blueln((Object)title);
                    break;
                }
                case TRACE: {
                    PrintUtil.purpleln((Object)title);
                    break;
                }
                default: {
                    PrintUtil.greenln((Object)title);
                }
            }
            if (content instanceof String) {
                this.out.println(content);
            } else {
                this.out.println(ONode.stringify((Object)content));
            }
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }
}

