/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.logging;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.noear.solon.Solon;
import org.noear.solon.core.Props;
import org.noear.solon.logging.event.Level;
import org.noear.solon.logging.model.LoggerLevelEntity;

public class LogOptions {
    private static volatile Level level = Level.TRACE;
    private static volatile Map<String, LoggerLevelEntity> loggerLevelMap = new LinkedHashMap<String, LoggerLevelEntity>();
    private static volatile boolean loggerLevelMapInited = false;

    public static void setLevel(Level level) {
        LogOptions.level = level;
    }

    public static Level getLevel() {
        return level;
    }

    public static void addLoggerLevel(String loggerExpr, Level level) {
        if (loggerExpr.endsWith(".*")) {
            loggerExpr = loggerExpr.substring(0, loggerExpr.length() - 1);
        }
        if (!loggerLevelMap.containsKey(loggerExpr)) {
            loggerLevelMap.put(loggerExpr, new LoggerLevelEntity(loggerExpr, level));
        }
    }

    public static Collection<LoggerLevelEntity> getLoggerLevels() {
        if (!loggerLevelMapInited) {
            LogOptions.loggerLevelMapInit();
        }
        return loggerLevelMap.values();
    }

    public static Level getLoggerLevel(String logger) {
        if (!loggerLevelMapInited) {
            LogOptions.loggerLevelMapInit();
        }
        if (logger == null) {
            return Level.INFO;
        }
        for (LoggerLevelEntity l : loggerLevelMap.values()) {
            if (!logger.startsWith(l.getLoggerExpr())) continue;
            return l.getLevel();
        }
        return LogOptions.getLevel();
    }

    private static synchronized void loggerLevelMapInit() {
        if (loggerLevelMapInited) {
            return;
        }
        if (Solon.global() == null) {
            return;
        }
        loggerLevelMapInited = true;
        Props props = Solon.cfg().getProp("solon.logging.logger");
        if (props.size() > 0) {
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String key = (String)k;
                String val = (String)v;
                if (key.endsWith(".level")) {
                    String loggerExpr = key.substring(0, key.length() - 6);
                    LogOptions.addLoggerLevel(loggerExpr, Level.of(val, Level.INFO));
                }
            }));
        }
    }
}

