/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.logging.appender;

import java.io.OutputStream;
import java.io.PrintStream;
import org.noear.snack.ONode;
import org.noear.solon.logging.appender.AppenderSimple;
import org.noear.solon.logging.event.Level;
import org.noear.solon.logging.event.LogEvent;

public abstract class OutputStreamAppender
extends AppenderSimple {
    protected PrintStream out;

    public OutputStreamAppender(OutputStream stream) {
        this.out = stream instanceof PrintStream ? (PrintStream)stream : new PrintStream(stream, true);
    }

    @Override
    public void append(LogEvent logEvent) {
        if (this.out == null) {
            return;
        }
        super.append(logEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void appendDo(Level level, String title, Object content) {
        PrintStream printStream = this.out;
        synchronized (printStream) {
            switch (level) {
                case ERROR: {
                    this.redln(title);
                    break;
                }
                case WARN: {
                    this.yellowln(title);
                    break;
                }
                case DEBUG: {
                    this.blueln(title);
                    break;
                }
                case TRACE: {
                    this.purpleln(title);
                    break;
                }
                default: {
                    this.out.println(title);
                }
            }
            if (content instanceof String) {
                this.out.println(content);
            } else {
                this.out.println(ONode.stringify((Object)content));
            }
        }
    }

    protected void redln(Object txt) {
        this.out.println("\u001b[31m" + txt);
        this.out.print("\u001b[0m");
    }

    protected void blueln(Object txt) {
        this.out.println("\u001b[34m" + txt);
        this.out.print("\u001b[0m");
    }

    protected void purpleln(String txt) {
        this.out.println("\u001b[35m" + txt);
        this.out.print("\u001b[0m");
    }

    protected void yellowln(Object txt) {
        this.out.println("\u001b[33m" + txt);
        this.out.print("\u001b[0m");
    }
}

