/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.logging;

import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.logging.AppenderHolder;
import org.noear.solon.logging.appender.ConsoleAppender;
import org.noear.solon.logging.event.Appender;
import org.noear.solon.logging.event.LogEvent;

public class AppenderManager {
    private static AppenderManager instance;
    private Map<String, AppenderHolder> appenderMap = new LinkedHashMap<String, AppenderHolder>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppenderManager getInstance() {
        if (instance != null) return instance;
        Class<AppenderManager> clazz = AppenderManager.class;
        synchronized (AppenderManager.class) {
            if (instance != null) return instance;
            instance = new AppenderManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AppenderManager() {
        this.registerDo("console", new ConsoleAppender());
    }

    public void register(String name, Appender appender) {
        this.registerDo(name, appender);
        LogUtil.global().trace("Logging: LogAppender registered from the " + appender.getClass().getTypeName() + "#" + name);
    }

    private void registerDo(String name, Appender appender) {
        this.appenderMap.putIfAbsent(name, new AppenderHolder(name, appender));
    }

    public AppenderHolder get(String name) {
        return this.appenderMap.get(name);
    }

    public void append(LogEvent logEvent) {
        for (AppenderHolder appender : this.appenderMap.values()) {
            appender.append(logEvent);
        }
    }

    public void stop() {
        for (AppenderHolder appender : this.appenderMap.values()) {
            appender.stop();
        }
    }
}

