/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.core.FactoryManager;
import org.slf4j.helpers.ThreadLocalMapOfStacks;
import org.slf4j.spi.MDCAdapter;

public class SolonMDCAdapter
implements MDCAdapter {
    private static final ThreadLocal<Map<String, String>> threadMap = FactoryManager.newThreadLocal(SolonMDCAdapter.class, (boolean)false);
    private static final ThreadLocalMapOfStacks threadLocalMapOfDeques = new ThreadLocalMapOfStacks();

    public void put(String key, String val) {
        Map<String, String> ht = threadMap.get();
        if (ht == null) {
            ht = new LinkedHashMap<String, String>();
            threadMap.set(ht);
        }
        ht.put(key, val);
    }

    public String get(String key) {
        Map<String, String> ht = threadMap.get();
        if (ht != null) {
            return ht.get(key);
        }
        return null;
    }

    public void remove(String key) {
        Map<String, String> ht = threadMap.get();
        if (ht != null) {
            ht.remove(key);
        }
    }

    public void clear() {
        threadMap.set(null);
    }

    public Map<String, String> getCopyOfContextMap() {
        Map<String, String> map = threadMap.get();
        if (map != null) {
            return new LinkedHashMap<String, String>(map);
        }
        return map;
    }

    public void setContextMap(Map<String, String> map) {
        threadMap.set(map);
    }

    public void pushByKey(String key, String value) {
        threadLocalMapOfDeques.pushByKey(key, value);
    }

    public String popByKey(String key) {
        return threadLocalMapOfDeques.popByKey(key);
    }

    public Deque<String> getCopyOfDequeByKey(String key) {
        return threadLocalMapOfDeques.getCopyOfDequeByKey(key);
    }

    public void clearDequeByKey(String key) {
        threadLocalMapOfDeques.clearDequeByKey(key);
    }
}

