/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.solon.integration;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.util.StatusPrinter;
import ch.qos.logback.solon.SolonConfigurator;
import ch.qos.logback.solon.integration.DefaultLogbackConfiguration;
import ch.qos.logback.solon.integration.LogbackConfigurator;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.fusesource.jansi.AnsiConsole;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.JavaUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.logging.LogIncubator;
import org.noear.solon.logging.LogOptions;
import org.noear.solon.logging.model.LoggerLevelEntity;
import org.slf4j.LoggerFactory;

public class LogIncubatorImpl
implements LogIncubator {
    public void incubate() throws Throwable {
        URL url;
        if (JavaUtil.IS_WINDOWS && !Solon.cfg().isFilesMode() && ClassUtil.hasClass(() -> AnsiConsole.class)) {
            try {
                AnsiConsole.systemInstall();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if ((url = this.getUrlOfConfig()) == null && ResourceUtil.hasResource((String)"logback.xml")) {
            return;
        }
        if (url == null && Utils.isNotEmpty((String)Solon.cfg().env())) {
            url = ResourceUtil.getResource((String)("logback-solon-" + Solon.cfg().env() + ".xml"));
        }
        if (url == null) {
            url = ResourceUtil.getResource((String)"logback-solon.xml");
        }
        this.initDo(url);
    }

    private void initDo(URL url) {
        try {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            loggerContext.reset();
            SolonConfigurator configurator = new SolonConfigurator();
            configurator.setContext((Context)loggerContext);
            if (url == null) {
                DefaultLogbackConfiguration configuration = new DefaultLogbackConfiguration();
                configuration.apply(new LogbackConfigurator(loggerContext));
            } else {
                configurator.doConfigure(url);
            }
            if (LogOptions.getLoggerLevels().size() > 0) {
                for (LoggerLevelEntity lle : LogOptions.getLoggerLevels()) {
                    Logger logger = loggerContext.getLogger(lle.getLoggerExpr());
                    logger.setLevel(Level.valueOf((String)lle.getLevel().name()));
                }
            }
            if (NativeDetector.inNativeImage()) {
                this.reportConfigurationErrorsIfNecessary(loggerContext);
            }
        }
        catch (JoranException e) {
            throw new IllegalStateException(e);
        }
    }

    private void reportConfigurationErrorsIfNecessary(LoggerContext loggerContext) {
        List statuses = loggerContext.getStatusManager().getCopyOfStatusList();
        StringBuilder errors = new StringBuilder();
        for (Status status : statuses) {
            if (status.getLevel() != 2) continue;
            errors.append(errors.length() > 0 ? String.format("%n", new Object[0]) : "");
            errors.append(status);
        }
        if (errors.length() > 0) {
            throw new IllegalStateException(String.format("Logback configuration error detected: %n%s", errors));
        }
        if (!StatusUtil.contextHasStatusListener((Context)loggerContext)) {
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext);
        }
    }

    private URL getUrlOfConfig() throws MalformedURLException {
        String logConfig = Solon.cfg().get("solon.logging.config");
        if (Utils.isNotEmpty((String)logConfig)) {
            File logConfigFile = new File(logConfig);
            if (logConfigFile.exists()) {
                return logConfigFile.toURI().toURL();
            }
            LogUtil.global().warn("Props: No log config file: " + logConfig);
        }
        return null;
    }
}

