/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.solon.integration;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.solon.SolonConfigurator;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.bean.InitializingBean;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.logging.LogOptions;
import org.noear.solon.logging.model.LoggerLevelEntity;
import org.slf4j.LoggerFactory;

public class XPluginImp
implements Plugin,
InitializingBean {
    public void afterInjection() throws Throwable {
        URL url = this.getUrlOfConfig();
        if (url == null && ResourceUtil.hasResource((String)"logback.xml")) {
            return;
        }
        if (url == null && Utils.isNotEmpty((String)Solon.cfg().env())) {
            url = ResourceUtil.getResource((String)("logback-solon-" + Solon.cfg().env() + ".xml"));
        }
        if (url == null) {
            url = ResourceUtil.getResource((String)"logback-solon.xml");
        }
        if (url == null) {
            boolean fileEnable = Solon.cfg().getBool("solon.logging.appender.file.enable", true);
            url = fileEnable ? ResourceUtil.getResource((String)"META-INF/solon_def/logback-def.xml") : ResourceUtil.getResource((String)"META-INF/solon_def/logback-def_nofile.xml");
        }
        this.initDo(url);
    }

    private URL getUrlOfConfig() throws MalformedURLException {
        String logConfig = Solon.cfg().get("solon.logging.config");
        if (Utils.isNotEmpty((String)logConfig)) {
            File logConfigFile = new File(logConfig);
            if (logConfigFile.exists()) {
                return logConfigFile.toURI().toURL();
            }
            LogUtil.global().warn("Props: No log config file: " + logConfig);
        }
        return null;
    }

    public void start(AopContext context) throws Throwable {
        this.afterInjection();
    }

    private void initDo(URL url) {
        if (url == null) {
            return;
        }
        try {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            SolonConfigurator configurator = new SolonConfigurator();
            configurator.setContext((Context)loggerContext);
            loggerContext.reset();
            configurator.doConfigure(url);
            if (LogOptions.getLoggerLevels().size() > 0) {
                for (LoggerLevelEntity lle : LogOptions.getLoggerLevels()) {
                    Logger logger = loggerContext.getLogger(lle.getLoggerExpr());
                    logger.setLevel(Level.valueOf((String)lle.getLevel().name()));
                }
            }
        }
        catch (JoranException e) {
            throw new IllegalStateException(e);
        }
    }
}

