/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.solon.integration;

import java.net.URI;
import java.net.URL;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.logging.LogOptions;
import org.noear.solon.logging.model.LoggerLevelEntity;

public class XPluginImp
implements Plugin {
    public void init(AopContext context) throws Throwable {
        URL url = Utils.getResource((String)"log4j2.xml");
        if (url == null) {
            if (Utils.isNotEmpty((String)Solon.cfg().env())) {
                url = Utils.getResource((String)("log4j2-solon-" + Solon.cfg().env() + ".xml"));
            }
            if (url == null) {
                url = Utils.getResource((String)"log4j2-solon.xml");
            }
            if (url == null) {
                url = Utils.getResource((String)"META-INF/solon_def/log4j2-def.xml");
            }
            if (url == null) {
                return;
            }
            this.initDo(url);
        }
    }

    public void start(AopContext context) throws Throwable {
        this.init(context);
    }

    private void initDo(URL url) {
        try {
            Configurator.reconfigure((URI)url.toURI());
            if (LogOptions.getLoggerLevels().size() > 0) {
                LoggerContext lctx = LoggerContext.getContext((boolean)false);
                Configuration lcfg = lctx.getConfiguration();
                for (LoggerLevelEntity lle : LogOptions.getLoggerLevels()) {
                    LoggerConfig logger = new LoggerConfig(lle.getLoggerExpr(), Level.valueOf((String)lle.getLevel().name()), true);
                    lcfg.addLogger(logger.getName(), logger);
                }
                lctx.updateLoggers();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

