/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.i18n.impl;

import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.Props;
import org.noear.solon.i18n.I18nBundle;

public class I18nBundleLocal
implements I18nBundle {
    Props bundle = new Props();
    String bundleName;
    Locale locale;

    public I18nBundleLocal(String bundleName, Locale locale) {
        if (locale == null) {
            locale = Solon.cfg().locale();
        }
        this.locale = locale;
        this.bundleName = bundleName;
        String bundleName2 = bundleName.replace(".", "/");
        Properties tmp = this.loadProperties(bundleName2, new String[]{".properties", ".yml"});
        if (tmp != null) {
            this.bundle.putAll((Map)tmp);
        }
        if ((tmp = this.loadProperties(bundleName2 + "_" + locale.getLanguage(), new String[]{".properties", ".yml"})) != null) {
            this.bundle.putAll((Map)tmp);
        }
        if ((tmp = this.loadProperties(bundleName2 + "_" + locale, new String[]{".properties", ".yml"})) != null) {
            this.bundle.putAll((Map)tmp);
        }
    }

    @Override
    public Props toProps() {
        return this.bundle;
    }

    @Override
    public Locale locale() {
        return this.locale;
    }

    @Override
    public String get(String key) {
        String tmp = this.bundle.getProperty(key);
        if (tmp == null) {
            throw new MissingResourceException("Can't find resource for bundle " + this.bundleName + ", key " + key, this.getClass().getName(), key);
        }
        return tmp;
    }

    private Properties loadProperties(String path, String[] extensions) {
        Properties tmp = null;
        for (String ext : extensions) {
            tmp = Utils.loadProperties((String)(path + ext));
            if (tmp != null) break;
        }
        return tmp;
    }
}

