/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.hotplug;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.solon.Solon;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanContainer;
import org.noear.solon.core.PluginEntity;
import org.noear.solon.core.Props;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.PluginUtil;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.hotplug.PluginClassLoader;

public class PluginPackage {
    private final File file;
    private final PluginClassLoader classLoader;
    private final List<PluginEntity> plugins;
    private boolean started;
    private AppContext context;
    private final ReentrantLock SYNC_LOCK = new ReentrantLock();

    public PluginPackage(File file, PluginClassLoader classLoader, List<PluginEntity> plugins) {
        this.file = file;
        this.plugins = plugins;
        this.classLoader = classLoader;
        this.context = new AppContext((ClassLoader)((Object)classLoader), new Props((ClassLoader)((Object)classLoader)));
        Solon.context().copyTo((BeanContainer)this.context);
        if (plugins.size() > 0) {
            plugins.sort(Comparator.comparingInt(PluginEntity::getPriority).reversed());
        }
    }

    public File getFile() {
        return this.file;
    }

    public PluginClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean getStarted() {
        return this.started;
    }

    public Class<?> loadClass(String className) {
        return ClassUtil.loadClass((ClassLoader)((Object)this.getClassLoader()), (String)className);
    }

    public <T> T tryInstance(String className) {
        return (T)ClassUtil.tryInstance((ClassLoader)((Object)this.getClassLoader()), (String)className);
    }

    public URL getResource(String name) {
        return ResourceUtil.getResource((ClassLoader)((Object)this.getClassLoader()), (String)name);
    }

    public String getResourceAsString(String name) throws IOException {
        return ResourceUtil.getResourceAsString((ClassLoader)((Object)this.getClassLoader()), (String)name, (String)Solon.encoding());
    }

    public String getResourceAsString(String name, String charset) throws IOException {
        return ResourceUtil.getResourceAsString((ClassLoader)((Object)this.getClassLoader()), (String)name, (String)charset);
    }

    public PluginPackage start() {
        this.SYNC_LOCK.lock();
        try {
            for (PluginEntity p1 : this.plugins) {
                p1.init(this.context);
            }
            for (PluginEntity p1 : this.plugins) {
                p1.start(this.context);
            }
            this.context.start();
            this.started = true;
            PluginPackage pluginPackage = this;
            return pluginPackage;
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void prestop() {
        this.SYNC_LOCK.lock();
        try {
            this.started = false;
            for (PluginEntity p1 : this.plugins) {
                p1.prestop();
            }
            this.context.prestop();
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void stop() {
        this.SYNC_LOCK.lock();
        try {
            this.started = false;
            for (PluginEntity p1 : this.plugins) {
                p1.stop();
            }
            this.context.stop();
            this.context.clear();
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public static PluginPackage loadJar(File file) {
        try {
            URL url = file.toURI().toURL();
            PluginClassLoader classLoader = new PluginClassLoader((ClassLoader)AppClassLoader.global());
            classLoader.addJar(url);
            ArrayList<PluginEntity> plugins = new ArrayList<PluginEntity>();
            PluginUtil.scanPlugins((ClassLoader)((Object)classLoader), plugins::add);
            return new PluginPackage(file, classLoader, plugins);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void unloadJar(PluginPackage pluginPackage) {
        try {
            pluginPackage.prestop();
            pluginPackage.stop();
            PluginClassLoader classLoader = pluginPackage.getClassLoader();
            classLoader.removeJar(pluginPackage.getFile());
            classLoader.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

