/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.docs.BasicAuth;
import org.noear.solon.docs.models.ApiExternalDocs;
import org.noear.solon.docs.models.ApiInfo;
import org.noear.solon.docs.models.ApiResource;
import org.noear.solon.docs.models.ApiScheme;
import org.noear.solon.docs.models.ApiVendorExtension;

public class DocDocket {
    private String version = "2.0";
    private List<ApiScheme> schemes = new ArrayList<ApiScheme>();
    private String groupName = "default";
    private String host;
    private String basePath;
    private Map<String, String> basicAuth = new LinkedHashMap<String, String>();
    private Class<?> globalResult;
    private Map<Integer, String> globalResponseCodes = new LinkedHashMap<Integer, String>();
    private boolean globalResponseInData = false;
    private ApiInfo info = new ApiInfo();
    private List<ApiResource> apis = new ArrayList<ApiResource>();
    private ApiExternalDocs externalDocs;
    private Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();

    public String version() {
        return this.version;
    }

    public DocDocket version(String version) {
        this.version = version;
        return this;
    }

    public String host() {
        return this.host;
    }

    public DocDocket host(String host) {
        this.host = host;
        return this;
    }

    public List<ApiScheme> schemes() {
        return this.schemes;
    }

    public DocDocket schemes(String ... schemes) {
        for (String s : schemes) {
            ApiScheme scheme = ApiScheme.forValue(s);
            if (scheme == null) continue;
            this.schemes.add(scheme);
        }
        return this;
    }

    public String groupName() {
        return this.groupName;
    }

    public DocDocket groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public String basePath() {
        return this.basePath;
    }

    public DocDocket basePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public Map<String, String> basicAuth() {
        return this.basicAuth;
    }

    public DocDocket basicAuth(String username, String password) {
        this.basicAuth.put(username, password);
        return this;
    }

    public DocDocket basicAuth(BasicAuth basicAuth) {
        if (basicAuth != null && basicAuth.isEnable() && Utils.isNotEmpty((String)basicAuth.getUsername())) {
            this.basicAuth.put(basicAuth.getUsername(), basicAuth.getPassword());
        }
        return this;
    }

    public List<ApiResource> apis() {
        return this.apis;
    }

    public DocDocket apis(String basePackage) {
        this.apis.add(new ApiResource(basePackage));
        return this;
    }

    public DocDocket apis(ApiResource apiResource) {
        this.apis.add(apiResource);
        return this;
    }

    public ApiInfo info() {
        return this.info;
    }

    public DocDocket info(ApiInfo info) {
        this.info = info;
        return this;
    }

    public boolean globalResponseInData() {
        return this.globalResponseInData;
    }

    public DocDocket globalResponseInData(boolean globalResponseInData) {
        this.globalResponseInData = globalResponseInData;
        return this;
    }

    public Map<Integer, String> globalResponseCodes() {
        return this.globalResponseCodes;
    }

    public DocDocket globalResponseCodes(Map<Integer, String> globalResponseCodes) {
        if (globalResponseCodes != null) {
            this.globalResponseCodes.putAll(globalResponseCodes);
        }
        return this;
    }

    public Class<?> globalResult() {
        return this.globalResult;
    }

    public DocDocket globalResult(Class<?> clz) {
        this.globalResult = clz;
        return this;
    }

    public ApiExternalDocs externalDocs() {
        return this.externalDocs;
    }

    public DocDocket externalDocs(ApiExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
        return this;
    }

    public DocDocket externalDocs(String description, String url) {
        this.externalDocs = new ApiExternalDocs();
        return this;
    }

    public Map<String, Object> vendorExtensions() {
        return this.vendorExtensions;
    }

    public DocDocket vendorExtensions(Map<String, Object> vendorExtensions) {
        if (vendorExtensions != null) {
            this.vendorExtensions.putAll(vendorExtensions);
        }
        return this;
    }

    public DocDocket vendorExtensions(String name, Object value) {
        this.vendorExtensions.put(name, value);
        return this;
    }

    public DocDocket vendorExtensions(ApiVendorExtension vendorExtension) {
        if (vendorExtension != null) {
            this.vendorExtensions.put(vendorExtension.getName(), vendorExtension.getValue());
        }
        return this;
    }

    public DocDocket vendorExtensions(List<ApiVendorExtension> vendorExtensions) {
        if (vendorExtensions != null) {
            for (ApiVendorExtension vendorExtension : vendorExtensions) {
                this.vendorExtensions.put(vendorExtension.getName(), vendorExtension.getValue());
            }
        }
        return this;
    }
}

