/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.cloud.model.EventTranListener;
import org.noear.solon.data.tran.TranListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTran
implements TranListener {
    private static Logger log = LoggerFactory.getLogger(EventTran.class);
    private Map<Class<?>, EventTranListener> listeners = new LinkedHashMap();
    private String id;

    public String getId() {
        if (this.id == null) {
            this.id = Utils.guid();
        }
        return this.id;
    }

    public void setListener(EventTranListener listener) {
        this.listeners.put(listener.getClass(), listener);
    }

    public <T extends EventTranListener> T getListener(Class<T> tClass) {
        return (T)this.listeners.get(tClass);
    }

    public void commit() throws Exception {
        for (Map.Entry<Class<?>, EventTranListener> entry : this.listeners.entrySet()) {
            entry.getValue().onCommit();
        }
    }

    public void rollback() {
        for (Map.Entry<Class<?>, EventTranListener> entry : this.listeners.entrySet()) {
            try {
                entry.getValue().onRollback();
            }
            catch (Throwable e) {
                log.warn("Rollback failure", e);
            }
        }
    }

    public void beforeCommit(boolean readOnly) throws Throwable {
        this.commit();
    }

    public void afterCompletion(int status) {
        if (status == 1) {
            this.rollback();
        }
    }
}

