/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud;

import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.Utils;

public class CloudProps {
    public static String LOG_DEFAULT_LOGGER;
    private String ROOT = "solon.cloud.@@.";
    private String SERVER = "solon.cloud.@@.server";
    private String TOKEN = "solon.cloud.@@.token";
    private String USERNAME = "solon.cloud.@@.username";
    private String PASSWORD = "solon.cloud.@@.password";
    private String ALARM = "solon.cloud.@@.alarm";
    private String CONFIG_ENABLE = "solon.cloud.@@.config.enable";
    private String CONFIG_SERVER = "solon.cloud.@@.config.server";
    private String CONFIG_LOAD = "solon.cloud.@@.config.load";
    private String CONFIG_LOAD_GROUP = "solon.cloud.@@.config.loadGroup";
    private String CONFIG_LOAD_KEY = "solon.cloud.@@.config.loadKey";
    private String CONFIG_REFRESH_INTERVAL = "solon.cloud.@@.config.refreshInterval";
    private String DISCOVERY_ENABLE = "solon.cloud.@@.discovery.enable";
    private String DISCOVERY_SERVER = "solon.cloud.@@.discovery.server";
    private String DISCOVERY_TAGS = "solon.cloud.@@.discovery.tags";
    private String DISCOVERY_UNSTABLE = "solon.cloud.@@.discovery.unstable";
    private String DISCOVERY_HEALTH_CHECK_PATH = "solon.cloud.@@.discovery.healthCheckPath";
    private String DISCOVERY_HEALTH_CHECK_INTERVAL = "solon.cloud.@@.discovery.healthCheckInterval";
    private String DISCOVERY_HEALTH_DETECTOR = "solon.cloud.@@.discovery.healthDetector";
    private String DISCOVERY_REFRESH_INTERVAL = "solon.cloud.@@.discovery.refreshInterval";
    private String EVENT_ENABLE = "solon.cloud.@@.event.enable";
    private String EVENT_SERVER = "solon.cloud.@@.event.server";
    private String EVENT_PREFETCH_COUNT = "solon.cloud.@@.event.prefetchCount";
    private String EVENT_PUBLISH_TIMEOUT = "solon.cloud.@@.event.publishTimeout";
    private String EVENT_CHANNEL = "solon.cloud.@@.event.channel";
    private String EVENT_BROKER = "solon.cloud.@@.event.broker";
    private String EVENT_GROUP = "solon.cloud.@@.event.group";
    private String EVENT_CONSUMER = "solon.cloud.@@.event.consumer";
    private String EVENT_PRODUCER = "solon.cloud.@@.event.producer";
    private String EVENT_CLIENT = "solon.cloud.@@.event.client";
    private String LOCK_ENABLE = "solon.cloud.@@.lock.enable";
    private String LOG_ENABLE = "solon.cloud.@@.log.enable";
    private String LOG_SERVER = "solon.cloud.@@.log.server";
    private String LOG_DEFAULT = "solon.cloud.@@.log.default";
    private String TRACE_ENABLE = "solon.cloud.@@.trace.enable";
    private String METRIC_ENABLE = "solon.cloud.@@.metric.enable";
    private String FILE_ENABLE = "solon.cloud.@@.file.enable";
    private String FILE_BUCKET = "solon.cloud.@@.file.bucket";
    private String FILE_ENDPOINT = "solon.cloud.@@.file.endpoint";
    private String FILE_REGION_ID = "solon.cloud.@@.file.regionId";
    private String FILE_ACCESS_KEY = "solon.cloud.@@.file.accessKey";
    private String FILE_SECRET_KEY = "solon.cloud.@@.file.secretKey";
    private String ID_ENABLE = "solon.cloud.@@.id.enable";
    private String ID_START = "solon.cloud.@@.id.start";
    private String LIST_ENABLE = "solon.cloud.@@.list.enable";
    private String JOB_ENABLE = "solon.cloud.@@.job.enable";
    private String JOB_SERVER = "solon.cloud.@@.job.server";
    private final String frame;

    public CloudProps(String frame) {
        this.frame = frame;
        this.ROOT = this.ROOT.replace("@@", frame);
        this.SERVER = this.SERVER.replace("@@", frame);
        this.TOKEN = this.TOKEN.replace("@@", frame);
        this.USERNAME = this.USERNAME.replace("@@", frame);
        this.PASSWORD = this.PASSWORD.replace("@@", frame);
        this.ALARM = this.ALARM.replace("@@", frame);
        this.CONFIG_ENABLE = this.CONFIG_ENABLE.replace("@@", frame);
        this.CONFIG_SERVER = this.CONFIG_SERVER.replace("@@", frame);
        this.CONFIG_LOAD = this.CONFIG_LOAD.replace("@@", frame);
        this.CONFIG_LOAD_GROUP = this.CONFIG_LOAD_GROUP.replace("@@", frame);
        this.CONFIG_LOAD_KEY = this.CONFIG_LOAD_KEY.replace("@@", frame);
        this.CONFIG_REFRESH_INTERVAL = this.CONFIG_REFRESH_INTERVAL.replace("@@", frame);
        this.DISCOVERY_ENABLE = this.DISCOVERY_ENABLE.replace("@@", frame);
        this.DISCOVERY_SERVER = this.DISCOVERY_SERVER.replace("@@", frame);
        this.DISCOVERY_TAGS = this.DISCOVERY_TAGS.replace("@@", frame);
        this.DISCOVERY_UNSTABLE = this.DISCOVERY_UNSTABLE.replace("@@", frame);
        this.DISCOVERY_HEALTH_CHECK_PATH = this.DISCOVERY_HEALTH_CHECK_PATH.replace("@@", frame);
        this.DISCOVERY_HEALTH_CHECK_INTERVAL = this.DISCOVERY_HEALTH_CHECK_INTERVAL.replace("@@", frame);
        this.DISCOVERY_HEALTH_DETECTOR = this.DISCOVERY_HEALTH_DETECTOR.replace("@@", frame);
        this.DISCOVERY_REFRESH_INTERVAL = this.DISCOVERY_REFRESH_INTERVAL.replace("@@", frame);
        this.EVENT_ENABLE = this.EVENT_ENABLE.replace("@@", frame);
        this.EVENT_SERVER = this.EVENT_SERVER.replace("@@", frame);
        this.EVENT_PREFETCH_COUNT = this.EVENT_PREFETCH_COUNT.replace("@@", frame);
        this.EVENT_PUBLISH_TIMEOUT = this.EVENT_PUBLISH_TIMEOUT.replace("@@", frame);
        this.EVENT_CHANNEL = this.EVENT_CHANNEL.replace("@@", frame);
        this.EVENT_BROKER = this.EVENT_BROKER.replace("@@", frame);
        this.EVENT_GROUP = this.EVENT_GROUP.replace("@@", frame);
        this.EVENT_CONSUMER = this.EVENT_CONSUMER.replace("@@", frame);
        this.EVENT_PRODUCER = this.EVENT_PRODUCER.replace("@@", frame);
        this.EVENT_CLIENT = this.EVENT_CLIENT.replace("@@", frame);
        this.LOCK_ENABLE = this.LOCK_ENABLE.replace("@@", frame);
        this.LOG_ENABLE = this.LOG_ENABLE.replace("@@", frame);
        this.LOG_SERVER = this.LOG_SERVER.replace("@@", frame);
        this.LOG_DEFAULT = this.LOG_DEFAULT.replace("@@", frame);
        this.TRACE_ENABLE = this.TRACE_ENABLE.replace("@@", frame);
        this.METRIC_ENABLE = this.METRIC_ENABLE.replace("@@", frame);
        this.FILE_ENABLE = this.FILE_ENABLE.replace("@@", frame);
        this.FILE_ENDPOINT = this.FILE_ENDPOINT.replace("@@", frame);
        this.FILE_REGION_ID = this.FILE_REGION_ID.replace("@@", frame);
        this.FILE_BUCKET = this.FILE_BUCKET.replace("@@", frame);
        this.FILE_ACCESS_KEY = this.FILE_ACCESS_KEY.replace("@@", frame);
        this.FILE_SECRET_KEY = this.FILE_SECRET_KEY.replace("@@", frame);
        this.ID_ENABLE = this.ID_ENABLE.replace("@@", frame);
        this.ID_START = this.ID_START.replace("@@", frame);
        this.LIST_ENABLE = this.LIST_ENABLE.replace("@@", frame);
        this.JOB_ENABLE = this.JOB_ENABLE.replace("@@", frame);
        this.JOB_SERVER = this.JOB_SERVER.replace("@@", frame);
    }

    public String getServer() {
        return Solon.cfg().get(this.SERVER);
    }

    public String getToken() {
        return Solon.cfg().get(this.TOKEN);
    }

    public String getUsername() {
        return Solon.cfg().get(this.USERNAME);
    }

    public String getPassword() {
        return Solon.cfg().get(this.PASSWORD);
    }

    public String getAlarm() {
        return Solon.cfg().get(this.ALARM);
    }

    public boolean getConfigEnable() {
        return Solon.cfg().getBool(this.CONFIG_ENABLE, true);
    }

    public String getConfigServer() {
        String tmp = Solon.cfg().get(this.CONFIG_SERVER);
        if (Utils.isEmpty((String)tmp)) {
            return this.getServer();
        }
        return tmp;
    }

    public String getConfigLoad() {
        return Solon.cfg().get(this.CONFIG_LOAD);
    }

    @Deprecated
    public String getConfigLoadGroup() {
        return Solon.cfg().get(this.CONFIG_LOAD_GROUP);
    }

    @Deprecated
    public String getConfigLoadKey() {
        return Solon.cfg().get(this.CONFIG_LOAD_KEY);
    }

    public String getConfigRefreshInterval(String def) {
        return Solon.cfg().get(this.CONFIG_REFRESH_INTERVAL, def);
    }

    public boolean getDiscoveryEnable() {
        return Solon.cfg().getBool(this.DISCOVERY_ENABLE, true);
    }

    public String getDiscoveryServer() {
        String tmp = Solon.cfg().get(this.DISCOVERY_SERVER);
        if (Utils.isEmpty((String)tmp)) {
            return this.getServer();
        }
        return tmp;
    }

    public String getDiscoveryTags() {
        return Solon.cfg().get(this.DISCOVERY_TAGS);
    }

    public boolean getDiscoveryUnstable() {
        return Solon.cfg().getBool(this.DISCOVERY_UNSTABLE, false);
    }

    public String getDiscoveryHealthCheckInterval(String def) {
        return Solon.cfg().get(this.DISCOVERY_HEALTH_CHECK_INTERVAL, def);
    }

    public String getDiscoveryRefreshInterval(String def) {
        return Solon.cfg().get(this.DISCOVERY_REFRESH_INTERVAL, def);
    }

    public boolean getEventEnable() {
        return Solon.cfg().getBool(this.EVENT_ENABLE, true);
    }

    public String getEventServer() {
        String tmp = Solon.cfg().get(this.EVENT_SERVER);
        if (Utils.isEmpty((String)tmp)) {
            return this.getServer();
        }
        return tmp;
    }

    public int getEventPrefetchCount() {
        return Solon.cfg().getInt(this.EVENT_PREFETCH_COUNT, 0);
    }

    public long getEventPublishTimeout() {
        return Solon.cfg().getLong(this.EVENT_PUBLISH_TIMEOUT, 0L);
    }

    public String getEventChannel() {
        return Solon.cfg().get(this.EVENT_CHANNEL, "");
    }

    public String getEventBroker() {
        return Solon.cfg().get(this.EVENT_BROKER, "");
    }

    public String getEventGroup() {
        return Solon.cfg().get(this.EVENT_GROUP, "");
    }

    public Properties getEventConsumerProps() {
        return Solon.cfg().getProp(this.EVENT_CONSUMER);
    }

    public Properties getEventProducerProps() {
        return Solon.cfg().getProp(this.EVENT_PRODUCER);
    }

    public Properties getEventClientProps() {
        return Solon.cfg().getProp(this.EVENT_CLIENT);
    }

    public boolean getLockEnable() {
        return Solon.cfg().getBool(this.LOCK_ENABLE, true);
    }

    public boolean getLogEnable() {
        return Solon.cfg().getBool(this.LOG_ENABLE, true);
    }

    public String getLogServer() {
        String tmp = Solon.cfg().get(this.LOG_SERVER);
        if (Utils.isEmpty((String)tmp)) {
            return this.getServer();
        }
        return tmp;
    }

    public String getLogDefault() {
        return Solon.cfg().get(this.LOG_DEFAULT);
    }

    public boolean getTraceEnable() {
        return Solon.cfg().getBool(this.TRACE_ENABLE, true);
    }

    public boolean getMetricEnable() {
        return Solon.cfg().getBool(this.METRIC_ENABLE, true);
    }

    public boolean getFileEnable() {
        return Solon.cfg().getBool(this.FILE_ENABLE, true);
    }

    public String getFileEndpoint() {
        return Solon.cfg().get(this.FILE_ENDPOINT);
    }

    public String getFileRegionId() {
        return Solon.cfg().get(this.FILE_REGION_ID);
    }

    public String getFileBucket() {
        return Solon.cfg().get(this.FILE_BUCKET);
    }

    public String getFileAccessKey() {
        return Solon.cfg().get(this.FILE_ACCESS_KEY);
    }

    public String getFileSecretKey() {
        return Solon.cfg().get(this.FILE_SECRET_KEY);
    }

    public boolean getIdEnable() {
        return Solon.cfg().getBool(this.ID_ENABLE, true);
    }

    public long getIdStart() {
        return Solon.cfg().getLong(this.ID_START, 0L);
    }

    public boolean getListEnable() {
        return Solon.cfg().getBool(this.LIST_ENABLE, true);
    }

    public boolean getJobEnable() {
        return Solon.cfg().getBool(this.JOB_ENABLE, true);
    }

    public String getJobServer() {
        String tmp = Solon.cfg().get(this.JOB_SERVER);
        if (Utils.isEmpty((String)tmp)) {
            return this.getServer();
        }
        return tmp;
    }

    public String getProp(String name) {
        return Solon.cfg().get(this.ROOT + name);
    }

    public void setProp(String name, String value) {
        Solon.cfg().setProperty(this.ROOT + name, value);
    }
}

