/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud;

import org.noear.nami.NamiManager;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.annotation.CloudBreaker;
import org.noear.solon.cloud.annotation.CloudConfig;
import org.noear.solon.cloud.annotation.CloudEvent;
import org.noear.solon.cloud.annotation.CloudJob;
import org.noear.solon.cloud.impl.CloudBreakerInterceptor;
import org.noear.solon.cloud.impl.CloudConfigBeanBuilder;
import org.noear.solon.cloud.impl.CloudConfigBeanInjector;
import org.noear.solon.cloud.impl.CloudDiscoveryServiceLocalImpl;
import org.noear.solon.cloud.impl.CloudEventBeanBuilder;
import org.noear.solon.cloud.impl.CloudJobBuilder;
import org.noear.solon.cloud.impl.CloudJobExtractor;
import org.noear.solon.cloud.impl.CloudLoadBalanceFactory;
import org.noear.solon.cloud.impl.CloudLogAppender;
import org.noear.solon.cloud.impl.CloudTraceServiceImpl;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.logging.AppenderManager;
import org.noear.solon.logging.event.Appender;

public class XPluginImp
implements Plugin {
    public void start(SolonApp app) {
        Aop.context().beanInjectorAdd(CloudConfig.class, (BeanInjector)CloudConfigBeanInjector.instance);
        Aop.context().beanBuilderAdd(CloudConfig.class, (BeanBuilder)CloudConfigBeanBuilder.instance);
        Aop.context().beanBuilderAdd(CloudEvent.class, (BeanBuilder)CloudEventBeanBuilder.instance);
        Aop.context().beanAroundAdd(CloudBreaker.class, (Interceptor)CloudBreakerInterceptor.instance);
        Aop.context().beanExtractorAdd(CloudJob.class, (BeanExtractor)CloudJobExtractor.instance);
        Aop.context().beanBuilderAdd(CloudJob.class, (BeanBuilder)CloudJobBuilder.instance);
        if (CloudClient.discovery() == null) {
            CloudManager.register(new CloudDiscoveryServiceLocalImpl());
        }
        if (CloudClient.discovery() != null) {
            CloudClient.discoveryPush();
            Bridge.upstreamFactorySet((LoadBalance.Factory)CloudLoadBalanceFactory.instance);
        }
        if (CloudClient.log() != null) {
            AppenderManager.getInstance().register("cloud", (Appender)new CloudLogAppender());
        }
        if (CloudClient.trace() == null) {
            CloudManager.register(new CloudTraceServiceImpl());
        }
        String serviceAndAddress = Instance.local().service() + "@" + Instance.local().address();
        NamiManager.reg(inv -> {
            inv.headers.put(CloudClient.trace().HEADER_TRACE_ID_NAME(), CloudClient.trace().getTraceId());
            inv.headers.put(CloudClient.trace().HEADER_FROM_ID_NAME(), serviceAndAddress);
            return inv.invoke();
        });
    }

    public void prestop() throws Throwable {
        if (CloudClient.discovery() != null && Utils.isNotEmpty((String)Solon.cfg().appName())) {
            for (Signal signal : Solon.global().signals()) {
                Instance instance = Instance.localNew(signal);
                CloudClient.discovery().deregister(Solon.cfg().appGroup(), instance);
                PrintUtil.info((String)"Cloud", (Object)("Service deregistered " + instance.service() + "@" + instance.uri()));
            }
        }
    }
}

