/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud;

import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.cloud.CloudConfigHandler;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.annotation.CloudConfig;
import org.noear.solon.cloud.annotation.CloudEvent;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.service.CloudEventService;
import org.noear.solon.cloud.service.CloudLockService;
import org.noear.solon.cloud.service.CloudLogService;
import org.noear.solon.cloud.service.CloudTraceService;
import org.noear.solon.core.util.PrintUtil;

public class CloudManager {
    private static CloudDiscoveryService discoveryService;
    private static CloudConfigService configService;
    private static CloudEventService eventService;
    private static CloudLockService lockService;
    private static CloudLogService logService;
    private static CloudTraceService traceService;
    protected static final Map<CloudConfig, CloudConfigHandler> configHandlerMap;
    protected static final Map<CloudEvent, CloudEventHandler> eventHandlerMap;

    public static void register(CloudConfig anno, CloudConfigHandler handler) {
        configHandlerMap.put(anno, handler);
    }

    public static void register(CloudEvent anno, CloudEventHandler handler) {
        eventHandlerMap.put(anno, handler);
    }

    public static void register(CloudConfigService service) {
        configService = service;
        PrintUtil.info((String)"Cloud", (Object)("CloudConfigService registered from the " + service.getClass().getTypeName()));
    }

    public static void register(CloudDiscoveryService service) {
        discoveryService = service;
        PrintUtil.info((String)"Cloud", (Object)("CloudDiscoveryService registered from the " + service.getClass().getTypeName()));
    }

    public static void register(CloudEventService service) {
        eventService = service;
        PrintUtil.info((String)"Cloud", (Object)("CloudEventService registered from the " + service.getClass().getTypeName()));
    }

    public static void register(CloudLockService service) {
        lockService = service;
        PrintUtil.info((String)"Cloud", (Object)("CloudLockService registered from the " + service.getClass().getTypeName()));
    }

    public static void register(CloudLogService service) {
        logService = service;
        PrintUtil.info((String)"Cloud", (Object)("CloudLogService registered from the " + service.getClass().getTypeName()));
    }

    public static void register(CloudTraceService service) {
        traceService = service;
        PrintUtil.info((String)"Cloud", (Object)("CloudTraceService registered from the " + service.getClass().getTypeName()));
    }

    protected static CloudConfigService configService() {
        return configService;
    }

    protected static CloudDiscoveryService discoveryService() {
        return discoveryService;
    }

    protected static CloudEventService eventService() {
        return eventService;
    }

    protected static CloudLockService lockService() {
        return lockService;
    }

    protected static CloudLogService logService() {
        return logService;
    }

    protected static CloudTraceService traceService() {
        return traceService;
    }

    static {
        configHandlerMap = new LinkedHashMap<CloudConfig, CloudConfigHandler>();
        eventHandlerMap = new LinkedHashMap<CloudEvent, CloudEventHandler>();
    }
}

