/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud;

import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.service.CloudEventService;
import org.noear.solon.cloud.service.CloudLogService;

public class CloudClient {
    public static CloudConfigService config() {
        return CloudManager.configService();
    }

    public static void configLoad(String group, String key) {
        if (CloudClient.config() == null) {
            return;
        }
        if (Utils.isNotEmpty((String)key)) {
            Config config = CloudClient.config().get(group, key);
            if (config != null && Utils.isNotEmpty((String)config.value)) {
                Properties properties = config.toProps();
                Solon.cfg().loadAdd(properties);
            }
            CloudClient.config().attention(group, key, cfg -> {
                Properties properties = config.toProps();
                Solon.cfg().loadAdd(properties);
            });
        }
    }

    public static CloudDiscoveryService discovery() {
        return CloudManager.discoveryService();
    }

    public static void discoveryPush(String hostname) {
        if (CloudClient.discovery() == null) {
            return;
        }
        if (Utils.isNotEmpty((String)Solon.cfg().appName())) {
            Instance instance = Instance.localNew();
            if (Utils.isNotEmpty((String)hostname)) {
                instance.address = hostname.contains(":") ? hostname : hostname + ":" + Solon.global().port();
            }
            CloudClient.discovery().register(Solon.cfg().appGroup(), instance);
        }
    }

    public static CloudEventService event() {
        return CloudManager.eventService();
    }

    public static CloudLogService log() {
        return CloudManager.logService();
    }
}

