/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.metrics.interceptor;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import org.noear.solon.Utils;
import org.noear.solon.cloud.metrics.annotation.MeterSummary;
import org.noear.solon.cloud.metrics.interceptor.BaseMeterInterceptor;
import org.noear.solon.core.aspect.Invocation;

public class MeterSummaryInterceptor
extends BaseMeterInterceptor<MeterSummary, DistributionSummary> {
    @Override
    protected MeterSummary getAnno(Invocation inv) {
        MeterSummary anno = (MeterSummary)inv.getMethodAnnotation(MeterSummary.class);
        if (anno == null) {
            anno = (MeterSummary)inv.getTargetAnnotation(MeterSummary.class);
        }
        return anno;
    }

    @Override
    protected String getAnnoName(MeterSummary anno) {
        return Utils.annoAlias((String)anno.value(), (String)anno.name());
    }

    @Override
    protected Object metering(Invocation inv, MeterSummary anno) throws Throwable {
        String meterName = this.getMeterName(inv, anno);
        DistributionSummary meter = this.getMeter(meterName, () -> {
            DistributionSummary.Builder builder = DistributionSummary.builder((String)meterName).tags((Iterable)this.getMeterTags(inv, anno.tags()));
            if (anno.maxValue() != Double.MAX_VALUE) {
                builder.maximumExpectedValue(Double.valueOf(anno.maxValue()));
            }
            if (anno.minValue() != Double.MIN_VALUE) {
                builder.minimumExpectedValue(Double.valueOf(anno.minValue()));
            }
            builder.scale(anno.scale());
            builder.publishPercentileHistogram(Boolean.valueOf(anno.percentilesHistogram()));
            builder.publishPercentiles(anno.percentiles());
            builder.serviceLevelObjectives(anno.serviceLevelObjectives());
            return builder.register((MeterRegistry)Metrics.globalRegistry);
        });
        Object rst = inv.invoke();
        if (rst instanceof Number) {
            meter.record(((Number)rst).doubleValue());
        }
        return rst;
    }
}

